/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.inventory;

import com.github.alexthe666.iceandfire.inventory.ContainerDragon;
import com.github.alexthe666.iceandfire.inventory.ContainerDragonForge;
import com.github.alexthe666.iceandfire.inventory.ContainerHippocampus;
import com.github.alexthe666.iceandfire.inventory.ContainerHippogryph;
import com.github.alexthe666.iceandfire.inventory.ContainerLectern;
import com.github.alexthe666.iceandfire.inventory.ContainerPodium;
import java.lang.reflect.Field;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="iceandfire", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IafContainerRegistry {
    public static final ContainerType IAF_LECTERN_CONTAINER = IafContainerRegistry.register(new ContainerType(ContainerLectern::new), "iaf_lectern");
    public static final ContainerType PODIUM_CONTAINER = IafContainerRegistry.register(new ContainerType(ContainerPodium::new), "podium");
    public static final ContainerType DRAGON_CONTAINER = IafContainerRegistry.register(new ContainerType(ContainerDragon::new), "dragon");
    public static final ContainerType HIPPOGRYPH_CONTAINER = IafContainerRegistry.register(new ContainerType(ContainerHippogryph::new), "hippogryph");
    public static final ContainerType HIPPOCAMPUS_CONTAINER = IafContainerRegistry.register(new ContainerType(ContainerHippocampus::new), "hippocampus");
    public static final ContainerType DRAGON_FORGE_CONTAINER = IafContainerRegistry.register(new ContainerType(ContainerDragonForge::new), "dragon_forge");

    public static ContainerType register(ContainerType type, String name) {
        type.setRegistryName(name);
        return type;
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        try {
            for (Field f : IafContainerRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof ContainerType) {
                    event.getRegistry().register((IForgeRegistryEntry)((ContainerType)obj));
                    continue;
                }
                if (!(obj instanceof ContainerType[])) continue;
                for (ContainerType container : (ContainerType[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)container);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

