/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MyrmexAIForage
extends Goal {
    private static final int RADIUS = 16;
    private final EntityMyrmexWorker myrmex;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int wanderRadius;
    private int chance;
    private PathResult path;
    private int failedToFindPath = 0;

    public MyrmexAIForage(EntityMyrmexWorker myrmex, int chanceIn) {
        this.myrmex = myrmex;
        this.targetSorter = new BlockSorter();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.chance = chanceIn;
    }

    public boolean func_75250_a() {
        if (!this.myrmex.canMove() || this.myrmex.holdingSomething() || !this.myrmex.func_70661_as().func_75500_f() || this.myrmex.isInHive() || this.myrmex.shouldEnterHive()) {
            return false;
        }
        if (!(this.myrmex.func_70661_as() instanceof AdvancedPathNavigate) || this.myrmex.func_184218_aH()) {
            return false;
        }
        if (this.myrmex.getWaitTicks() > 0) {
            return false;
        }
        List<BlockPos> edibleBlocks = this.getEdibleBlocks();
        if (edibleBlocks.isEmpty()) {
            return this.myrmex.func_70681_au().nextInt(this.chance) == 0 && this.increaseRadiusAndWander();
        }
        edibleBlocks.sort(this.targetSorter);
        this.targetBlock = edibleBlocks.get(0);
        this.path = ((AdvancedPathNavigate)this.myrmex.func_70661_as()).moveToXYZ(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p(), 1.0);
        return this.targetBlock != null && this.myrmex.func_70681_au().nextInt(this.chance) == 0;
    }

    public boolean func_75253_b() {
        if (this.targetBlock == null) {
            return false;
        }
        if (this.myrmex.getWaitTicks() > 0) {
            return false;
        }
        if (this.myrmex.shouldEnterHive()) {
            this.myrmex.keepSearching = false;
            return false;
        }
        return !this.myrmex.holdingSomething();
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.myrmex.keepSearching) {
            if (this.myrmex.isCloseEnoughToTarget(this.targetBlock, 12.0) || !this.myrmex.pathReachesTarget(this.path, this.targetBlock, 12.0)) {
                this.failedToFindPath = 0;
                List<BlockPos> edibleBlocks = this.getEdibleBlocks();
                if (!edibleBlocks.isEmpty()) {
                    this.myrmex.keepSearching = false;
                    edibleBlocks.sort(this.targetSorter);
                    this.targetBlock = edibleBlocks.get(0);
                    this.path = ((AdvancedPathNavigate)this.myrmex.func_70661_as()).moveToXYZ(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p(), 1.0);
                } else {
                    this.increaseRadiusAndWander();
                }
            }
        } else if (!this.myrmex.keepSearching) {
            this.failedToFindPath = 0;
            BlockState block = this.myrmex.field_70170_p.func_180495_p(this.targetBlock);
            if (EntityMyrmexBase.isEdibleBlock(block)) {
                double distance = this.getDistanceSq(this.targetBlock);
                if (distance < 6.0) {
                    block.func_177230_c();
                    List drops = Block.func_220070_a((BlockState)block, (ServerWorld)((ServerWorld)this.myrmex.field_70170_p), (BlockPos)this.targetBlock, (TileEntity)this.myrmex.field_70170_p.func_175625_s(this.targetBlock));
                    if (!drops.isEmpty()) {
                        this.myrmex.field_70170_p.func_175655_b(this.targetBlock, false);
                        ItemStack heldStack = ((ItemStack)drops.get(0)).func_77946_l();
                        heldStack.func_190920_e(1);
                        ((ItemStack)drops.get(0)).func_190918_g(1);
                        this.myrmex.func_184611_a(Hand.MAIN_HAND, heldStack);
                        for (ItemStack stack : drops) {
                            ItemEntity itemEntity = new ItemEntity(this.myrmex.field_70170_p, (double)this.targetBlock.func_177958_n() + this.myrmex.func_70681_au().nextDouble(), (double)this.targetBlock.func_177956_o() + this.myrmex.func_70681_au().nextDouble(), (double)this.targetBlock.func_177952_p() + this.myrmex.func_70681_au().nextDouble(), stack);
                            itemEntity.func_174869_p();
                            if (this.myrmex.field_70170_p.field_72995_K) continue;
                            this.myrmex.field_70170_p.func_217376_c((Entity)itemEntity);
                        }
                        this.targetBlock = null;
                        this.func_75251_c();
                        this.myrmex.keepSearching = false;
                        this.wanderRadius = 16;
                        return;
                    }
                } else if (!this.myrmex.pathReachesTarget(this.path, this.targetBlock, 12.0)) {
                    List<BlockPos> edibleBlocks = this.getEdibleBlocks();
                    if (!edibleBlocks.isEmpty()) {
                        this.myrmex.keepSearching = false;
                        this.targetBlock = edibleBlocks.get(this.myrmex.func_70681_au().nextInt(edibleBlocks.size()));
                        this.path = ((AdvancedPathNavigate)this.myrmex.func_70661_as()).moveToXYZ(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p(), 1.0);
                    } else {
                        this.myrmex.keepSearching = true;
                    }
                }
            }
        }
    }

    public void func_75251_c() {
        this.targetBlock = null;
        this.myrmex.keepSearching = true;
    }

    private double getDistanceSq(BlockPos pos) {
        double deltaX = this.myrmex.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
        double deltaY = this.myrmex.func_226278_cu_() + (double)this.myrmex.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
        double deltaZ = this.myrmex.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    private List<BlockPos> getEdibleBlocks() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos.func_218281_b((BlockPos)this.myrmex.func_233580_cy_().func_177982_a(-16, -8, -16), (BlockPos)this.myrmex.func_233580_cy_().func_177982_a(16, 8, 16)).map(BlockPos::func_185334_h).forEach(pos -> {
            if (!MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this.myrmex, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) && EntityMyrmexBase.isEdibleBlock(this.myrmex.field_70170_p.func_180495_p(pos))) {
                allBlocks.add((BlockPos)pos);
                this.myrmex.keepSearching = false;
            }
        });
        return allBlocks;
    }

    private boolean increaseRadiusAndWander() {
        Vector3d vec;
        this.myrmex.keepSearching = true;
        if (this.myrmex.getHive() != null) {
            this.wanderRadius = this.myrmex.getHive().getWanderRadius();
            this.myrmex.getHive().setWanderRadius(this.wanderRadius * 2);
        }
        this.wanderRadius *= 2;
        if (this.wanderRadius >= IafConfig.myrmexMaximumWanderRadius) {
            this.wanderRadius = IafConfig.myrmexMaximumWanderRadius;
            this.myrmex.setWaitTicks(80 + new Random().nextInt(40));
            ++this.failedToFindPath;
            if (this.failedToFindPath >= 10) {
                this.myrmex.setWaitTicks(800 + new Random().nextInt(40));
            }
        }
        if ((vec = RandomPositionGenerator.func_75463_a((CreatureEntity)this.myrmex, (int)this.wanderRadius, (int)7)) != null) {
            this.targetBlock = new BlockPos(vec);
        }
        if (this.targetBlock != null) {
            this.path = ((AdvancedPathNavigate)this.myrmex.func_70661_as()).moveToXYZ(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p(), 1.0);
            return true;
        }
        return false;
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = MyrmexAIForage.this.getDistanceSq(pos1);
            double distance2 = MyrmexAIForage.this.getDistanceSq(pos2);
            return Double.compare(distance1, distance2);
        }
    }
}

