/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderHippocampus
extends MobRenderer<EntityHippocampus, ModelHippocampus> {
    private static final ResourceLocation VARIANT_0 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_0.png");
    private static final ResourceLocation VARIANT_0_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_0_blinking.png");
    private static final ResourceLocation VARIANT_1 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_1.png");
    private static final ResourceLocation VARIANT_1_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_1_blinking.png");
    private static final ResourceLocation VARIANT_2 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_2.png");
    private static final ResourceLocation VARIANT_2_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_2_blinking.png");
    private static final ResourceLocation VARIANT_3 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_3.png");
    private static final ResourceLocation VARIANT_3_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_3_blinking.png");
    private static final ResourceLocation VARIANT_4 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_4.png");
    private static final ResourceLocation VARIANT_4_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_4_blinking.png");
    private static final ResourceLocation VARIANT_5 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_5.png");
    private static final ResourceLocation VARIANT_5_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_5_blinking.png");

    public RenderHippocampus(EntityRendererManager renderManager) {
        super(renderManager, (EntityModel)new ModelHippocampus(), 0.8f);
        this.field_177097_h.add(new LayerHippocampusRainbow(this));
        this.field_177097_h.add(new LayerHippocampusSaddle(this));
    }

    @Nullable
    public ResourceLocation getEntityTexture(EntityHippocampus entity) {
        switch (entity.getVariant()) {
            default: {
                return entity.isBlinking() ? VARIANT_0_BLINK : VARIANT_0;
            }
            case 1: {
                return entity.isBlinking() ? VARIANT_1_BLINK : VARIANT_1;
            }
            case 2: {
                return entity.isBlinking() ? VARIANT_2_BLINK : VARIANT_2;
            }
            case 3: {
                return entity.isBlinking() ? VARIANT_3_BLINK : VARIANT_3;
            }
            case 4: {
                return entity.isBlinking() ? VARIANT_4_BLINK : VARIANT_4;
            }
            case 5: 
        }
        return entity.isBlinking() ? VARIANT_5_BLINK : VARIANT_5;
    }

    private class LayerHippocampusRainbow
    extends LayerRenderer<EntityHippocampus, ModelHippocampus> {
        private final RenderHippocampus renderer;
        private final RenderType TEXTURE;
        private final RenderType TEXTURE_BLINK;

        public LayerHippocampusRainbow(RenderHippocampus renderer) {
            super((IEntityRenderer)renderer);
            this.TEXTURE = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippocampus/rainbow.png"));
            this.TEXTURE_BLINK = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippocampus/rainbow_blink.png"));
            this.renderer = renderer;
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityHippocampus hippo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (hippo.func_145818_k_() && hippo.func_200201_e().toString().toLowerCase().contains("rainbow")) {
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(hippo.isBlinking() ? this.TEXTURE_BLINK : this.TEXTURE);
                int i1 = 25;
                int i = hippo.field_70173_aa / 25 + hippo.func_145782_y();
                int j = DyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f = ((float)(hippo.field_70173_aa % 25) + partialTicks) / 25.0f;
                float[] afloat1 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)k));
                float[] afloat2 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)l));
                ((ModelHippocampus)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)hippo, (float)0.0f), afloat1[0] * (1.0f - f) + afloat2[0] * f, afloat1[1] * (1.0f - f) + afloat2[1] * f, afloat1[2] * (1.0f - f) + afloat2[2] * f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class LayerHippocampusSaddle
    extends LayerRenderer<EntityHippocampus, ModelHippocampus> {
        private final RenderHippocampus renderer;
        private final RenderType SADDLE_TEXTURE;
        private final RenderType BRIDLE;
        private final RenderType CHEST;
        private final RenderType TEXTURE_DIAMOND;
        private final RenderType TEXTURE_GOLD;
        private final RenderType TEXTURE_IRON;

        public LayerHippocampusSaddle(RenderHippocampus renderer) {
            super((IEntityRenderer)renderer);
            this.SADDLE_TEXTURE = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippocampus/saddle.png"));
            this.BRIDLE = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippocampus/bridle.png"));
            this.CHEST = RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippocampus/chest.png"));
            this.TEXTURE_DIAMOND = RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippocampus/armor_diamond.png"));
            this.TEXTURE_GOLD = RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippocampus/armor_gold.png"));
            this.TEXTURE_IRON = RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippocampus/armor_iron.png"));
            this.renderer = renderer;
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityHippocampus hippo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder;
            if (hippo.isSaddled()) {
                ivertexbuilder = bufferIn.getBuffer(this.SADDLE_TEXTURE);
                ((ModelHippocampus)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isSaddled() && hippo.func_184179_bs() != null) {
                ivertexbuilder = bufferIn.getBuffer(this.BRIDLE);
                ((ModelHippocampus)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isChested()) {
                ivertexbuilder = bufferIn.getBuffer(this.CHEST);
                ((ModelHippocampus)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.getArmor() != 0) {
                RenderType type = null;
                switch (hippo.getArmor()) {
                    case 1: {
                        type = this.TEXTURE_IRON;
                        break;
                    }
                    case 2: {
                        type = this.TEXTURE_GOLD;
                        break;
                    }
                    case 3: {
                        type = this.TEXTURE_DIAMOND;
                    }
                }
                IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(type);
                ((ModelHippocampus)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

