/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.server.command.search.condition;

import com.terraforged.engine.world.heightmap.Heightmap;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.engine.world.terrain.TerrainType;
import com.terraforged.mod.server.command.search.condition.ExactTerrainMatch;
import com.terraforged.mod.server.command.search.condition.SearchCondition;
import com.terraforged.mod.server.command.search.condition.TerrainMatch;
import com.terraforged.mod.server.command.search.condition.VolcanoMatch;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TerrainConditions {
    private static final Map<Terrain, SearchCondition.Factory> CONDITIONS = new ConcurrentHashMap<Terrain, SearchCondition.Factory>();

    public static SearchCondition get(Terrain terrain, Heightmap heightmap) {
        SearchCondition.Factory factory = CONDITIONS.get(terrain);
        if (factory == null) {
            return new TerrainMatch(terrain, heightmap);
        }
        return factory.create(terrain, heightmap);
    }

    public static void register(Terrain terrain, SearchCondition.Factory factory) {
        CONDITIONS.putIfAbsent(terrain, factory);
    }

    static {
        TerrainConditions.register(TerrainType.DEEP_OCEAN, ExactTerrainMatch::new);
        TerrainConditions.register(TerrainType.SHALLOW_OCEAN, ExactTerrainMatch::new);
        TerrainConditions.register(TerrainType.BEACH, ExactTerrainMatch::new);
        TerrainConditions.register(TerrainType.RIVER, ExactTerrainMatch::new);
        TerrainConditions.register(TerrainType.LAKE, ExactTerrainMatch::new);
        TerrainConditions.register(TerrainType.WETLAND, ExactTerrainMatch::new);
        TerrainConditions.register(TerrainType.MOUNTAIN_CHAIN, ExactTerrainMatch::new);
        TerrainConditions.register(TerrainType.VOLCANO_PIPE, VolcanoMatch::new);
    }
}

