/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler.watchdog;

import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.profiler.timings.TimingStack;
import com.terraforged.mod.profiler.watchdog.UncheckedException;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.chunk.IChunk;

public class ChunkTimeoutException
extends UncheckedException {
    private static final String MESSAGE = "Chunk-generation timed-out! Possible deadlock detected!\n\n\t\t\tA single chunk has taken over %s to generate!\n\t\t\tWe crashed whilst generating: %s %s\n\t\t\tIt had been generating for: %s (%s)\n";
    private static final String TABLE_HEADER_ONE = "\n\t\t\tThe slowest performing feature/structure before that was:";
    private static final String TABLE_HEADER_MULT = "\n\t\t\tThe %s slowest performing features/structures before that were:";
    private static final String TABLE_FORMAT = "\n\t\t\t\t%1$-8s%2$-12s%3$-10s%4$-10s%5$-1s";
    private static final String TABLE_FOOTER = "\n";
    private final IChunk chunk;
    private final TFChunkGenerator generator;

    protected ChunkTimeoutException(String phase, Object identity, long totalTime, long itemTime, TimingStack stack, IChunk chunk, TFChunkGenerator generator, Thread thread) {
        super(ChunkTimeoutException.createMessage(phase, identity, totalTime, itemTime, stack), thread.getStackTrace());
        this.chunk = chunk;
        this.generator = generator;
        this.setStackTrace(thread.getStackTrace());
    }

    public IChunk getChunk() {
        return this.chunk;
    }

    public TFChunkGenerator getGenerator() {
        return this.generator;
    }

    private static String createMessage(String phase, Object identity, long totalTime, long itemTime, TimingStack stack) {
        return ChunkTimeoutException.createSummary(phase, identity, totalTime, itemTime) + ChunkTimeoutException.createTable(stack, totalTime);
    }

    private static String createSummary(String phase, Object identity, long totalTime, long itemTime) {
        String phaseName = ChunkTimeoutException.nonNullStringValue(phase, "unknown");
        String identName = ChunkTimeoutException.nonNullStringValue(identity, "unknown");
        String total = ChunkTimeoutException.getTime(totalTime);
        String item = ChunkTimeoutException.getTime(itemTime);
        String rating = ChunkTimeoutException.getImpact(itemTime, totalTime);
        return String.format(MESSAGE, total, phaseName, identName, item, rating);
    }

    private static String createTable(TimingStack stack, long totalTime) {
        if (stack.size() > 0) {
            StringBuilder sb = new StringBuilder(2048);
            sb.append(ChunkTimeoutException.getTableTitle(stack));
            sb.append(String.format(TABLE_FORMAT, "Index", "Type", "Time", "Impact", "Identity"));
            AtomicInteger counter = new AtomicInteger(1);
            stack.iterate(sb, (type, identity, time, ctx) -> {
                String index = ChunkTimeoutException.getIndex(counter.getAndIncrement());
                String duration = ChunkTimeoutException.getTime(time);
                String percentage = ChunkTimeoutException.getImpact(time, totalTime);
                ctx.append(String.format(TABLE_FORMAT, index, type, duration, percentage, identity));
            });
            return sb.append(TABLE_FOOTER).toString();
        }
        return "";
    }

    private static String getTableTitle(TimingStack stack) {
        int size = stack.size();
        if (size == 0) {
            return TABLE_HEADER_ONE;
        }
        return String.format(TABLE_HEADER_MULT, size);
    }

    private static String getIndex(int index) {
        return index < 10 ? "[0" + index + "]" : "[" + index + "]";
    }

    private static String getTime(long timeMS) {
        return timeMS > 1000L ? String.format("%.3fs", (double)timeMS / 1000.0) : timeMS + "ms";
    }

    private static String getImpact(long timeMS, long totalMS) {
        return String.format("%.2f%%", 100.0 * (double)timeMS / (double)totalMS);
    }
}

