/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager;

import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.featuremanager.FeatureDecorator;
import com.terraforged.mod.featuremanager.biome.BiomeFeatures;
import com.terraforged.mod.featuremanager.data.DataManager;
import com.terraforged.mod.featuremanager.modifier.FeatureModifierLoader;
import com.terraforged.mod.featuremanager.modifier.FeatureModifiers;
import com.terraforged.mod.featuremanager.modifier.ModifierSet;
import com.terraforged.mod.featuremanager.template.template.TemplateManager;
import com.terraforged.mod.featuremanager.transformer.InjectionPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FeatureManager
implements FeatureDecorator {
    public static final Logger LOG = LogManager.getLogger((String)"FeatureManager");
    public static final Marker INIT = MarkerManager.getMarker((String)"Init");
    private final Map<Biome, BiomeFeatures> biomes;

    public FeatureManager(Map<Biome, BiomeFeatures> biomes) {
        this.biomes = biomes;
    }

    @Override
    public FeatureManager getFeatureManager() {
        return this;
    }

    public BiomeFeatures getFeatures(Biome biome) {
        return this.biomes.getOrDefault(biome, BiomeFeatures.NONE);
    }

    public static FeatureModifiers modifiers(DataManager data, boolean load, TFBiomeContext context) {
        if (load) {
            return FeatureModifierLoader.load(data, context);
        }
        return new FeatureModifiers(context);
    }

    public static void initData(DataManager manager) {
        TemplateManager.getInstance().load(manager);
    }

    public static void clearData() {
        TemplateManager.getInstance().clear();
    }

    public static FeatureManager create(FeatureModifiers modifiers) {
        LOG.debug(INIT, "Initializing FeatureManager");
        int predicates = modifiers.getPredicates().size();
        int replacers = modifiers.getReplacers().size();
        int injectors = modifiers.getInjectors().size();
        int transformers = modifiers.getTransformers().size();
        LOG.debug(INIT, " Predicates: {}, Replacers: {}, Injectors: {}, Transformers: {}", (Object)predicates, (Object)replacers, (Object)injectors, (Object)transformers);
        modifiers.sort();
        LOG.debug(INIT, " Compiling biome feature lists");
        HashMap<Biome, BiomeFeatures> biomes = new HashMap<Biome, BiomeFeatures>();
        for (Biome biome : modifiers.getContext().biomes) {
            BiomeFeatures features;
            try {
                features = FeatureManager.compute(biome, modifiers);
            }
            catch (Throwable t) {
                t.printStackTrace();
                features = BiomeFeatures.NONE;
            }
            biomes.put(biome, features);
        }
        LOG.debug(INIT, " Initialization complete");
        return new FeatureManager(biomes);
    }

    private static BiomeFeatures compute(Biome biome, FeatureModifiers modifiers) {
        BiomeFeatures.Builder builder = BiomeFeatures.builder();
        List features = biome.func_242440_e().func_242498_c();
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            builder.add(stage, modifiers.getAppenders(stage, biome, InjectionPosition.HEAD));
            if (stage.ordinal() >= features.size()) break;
            for (Supplier feature : (List)features.get(stage.ordinal())) {
                ModifierSet modifierSet = modifiers.getFeature(stage, biome, (ConfiguredFeature)feature.get());
                builder.add(stage, modifierSet.before);
                builder.add(stage, modifierSet.feature);
                builder.add(stage, modifierSet.after);
            }
            builder.add(stage, modifiers.getAppenders(stage, biome, InjectionPosition.TAIL));
        }
        return builder.build();
    }
}

