/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data.gen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.featuremanager.matcher.BiomeFeatureMatcher;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcher;
import com.terraforged.mod.featuremanager.matcher.feature.FeatureMatcher;
import com.terraforged.mod.featuremanager.modifier.FeatureModifiers;
import com.terraforged.mod.featuremanager.modifier.Jsonifiable;
import com.terraforged.mod.featuremanager.modifier.Modifier;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public class FeatureInjectorProvider
implements IDataProvider {
    private final Path dir;
    private final TFBiomeContext context = TFBiomeContext.dynamic();
    private final Map<String, Modifier<Jsonifiable>> modifiers = new HashMap<String, Modifier<Jsonifiable>>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final BiomeMatcher vanillaAndTF;

    public FeatureInjectorProvider(DataGenerator gen, String namespace) {
        this.dir = gen.func_200391_b().resolve(Paths.get("data", namespace, "features"));
        this.vanillaAndTF = BiomeMatcher.of(this.getContext(), "minecraft:*", "terraforged:*");
    }

    public TFBiomeContext getContext() {
        return this.context;
    }

    public void add(String path, FeatureMatcher featureMatcher, Jsonifiable modifier) {
        this.add(path, BiomeMatcher.ANY, featureMatcher, modifier);
    }

    public void addTFVanilla(String path, FeatureMatcher featureMatcher, Jsonifiable modifier) {
        this.add(path, this.vanillaAndTF, featureMatcher, modifier);
    }

    public void add(String path, BiomeMatcher biomeMatcher, FeatureMatcher featureMatcher, Jsonifiable modifier) {
        this.add(path, new BiomeFeatureMatcher(biomeMatcher, featureMatcher), modifier);
    }

    public void add(String path, BiomeFeatureMatcher matcher, Jsonifiable modifier) {
        this.add(path, new Modifier<Jsonifiable>(matcher, modifier));
    }

    public void add(String path, Modifier<Jsonifiable> modifier) {
        this.modifiers.put(path, modifier);
    }

    public void add(FeatureModifiers modifiers) {
    }

    public String func_200397_b() {
        return "Feature_Injectors";
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        for (Map.Entry<String, Modifier<Jsonifiable>> entry : this.modifiers.entrySet()) {
            Path dest = this.dir.resolve(entry.getKey() + ".json");
            Modifier<Jsonifiable> modifier = entry.getValue();
            JsonObject root = new JsonObject();
            modifier.getMatcher().append(root, this.context);
            modifier.getModifier().append(root, this.context);
            this.write((JsonElement)root, dest, cache);
        }
    }

    private void write(JsonElement json, Path dest, DirectoryCache cache) throws IOException {
        String data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)this.gson.toJson(json));
        String hash = IDataProvider.field_208307_a.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.func_208323_a(dest), hash) || !Files.exists(dest, new LinkOption[0])) {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(dest, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.func_208316_a(dest, hash);
    }
}

