/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.analyser.BiomeAnalyser;
import com.terraforged.mod.data.WorldGenBiomes;
import com.terraforged.mod.data.WorldGenBlocks;
import com.terraforged.mod.data.WorldGenExport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class DataGen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void dumpData(MinecraftServer server) {
        TFBiomeContext context = new TFBiomeContext((Registry<Biome>)server.func_244267_aX().func_243612_b(Registry.field_239720_u_));
        File dataDir = new File("data").getAbsoluteFile();
        Biome[] biomes = BiomeAnalyser.getOverworldBiomes(context);
        WorldGenBiomes.genBiomeMap(dataDir, context);
        WorldGenBiomes.genBiomeWeights(dataDir, context);
        WorldGenBlocks.genBlockTags(dataDir);
        WorldGenExport.export(dataDir, server, biomes);
    }

    protected static void write(File file, IOConsumer consumer) {
        if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                consumer.accept(writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static void write(JsonElement json, File dataDir, String path) {
        File file = new File(dataDir, path).getAbsoluteFile();
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            DataGen.write(json, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void write(JsonElement json, Writer writer) {
        GSON.toJson(json, (Appendable)writer);
    }

    protected static String getJsonPath(String type, ResourceLocation location) {
        if (location == null) {
            return "unknown";
        }
        return location.func_110624_b() + "/" + type + "/" + location.func_110623_a() + ".json";
    }

    protected static String getJsonPath(RegistryKey<?> registryKey) {
        ResourceLocation registry = registryKey.getRegistryName();
        ResourceLocation name = registryKey.func_240901_a_();
        return name.func_110624_b() + "/" + registry.func_110623_a() + "/" + name.func_110623_a() + ".json";
    }

    public static interface IOConsumer {
        public void accept(Writer var1) throws IOException;
    }
}

