/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.terraforged.mod.client.gui.element.Element;
import com.terraforged.mod.client.gui.element.TFLabel;
import com.terraforged.mod.client.gui.element.TFRandButton;
import com.terraforged.mod.client.gui.element.TFSlider;
import com.terraforged.mod.client.gui.element.TFTextBox;
import com.terraforged.mod.client.gui.element.TFToggle;
import com.terraforged.mod.client.gui.screen.ScrollPane;
import com.terraforged.mod.client.gui.screen.overlay.OverlayRenderer;
import com.terraforged.mod.client.gui.screen.overlay.OverlayScreen;
import com.terraforged.mod.util.DataUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class Page
implements IGuiEventListener,
OverlayRenderer {
    protected static final Runnable NO_CALLBACK = () -> {};
    private static final int SLIDER_HEIGHT = 20;
    private static final int SLIDER_PAD = 2;
    private final Column[] columns;
    private final float[] sizes;
    private final int hpad;
    private final int vpad;
    protected OverlayScreen parent;

    public Page(int hpad, int vpad, float ... columnSizes) {
        this.hpad = hpad;
        this.vpad = vpad;
        this.sizes = columnSizes;
        this.columns = new Column[columnSizes.length];
    }

    public abstract void callback(Runnable var1);

    public abstract void save();

    public abstract void init(OverlayScreen var1);

    @Override
    public void renderOverlays(MatrixStack matrixStack, Screen screen, int mouseX, int mouseY) {
        for (Column column : this.columns) {
            if (column.scrollPane.func_231039_at__().isEmpty()) continue;
            column.scrollPane.renderOverlays(matrixStack, screen, mouseX, mouseY);
        }
    }

    public void visit(Consumer<ScrollPane> consumer) {
        for (Column column : this.columns) {
            if (column.scrollPane.func_231039_at__().isEmpty()) continue;
            consumer.accept(column.scrollPane);
        }
    }

    public boolean action(Function<ScrollPane, Boolean> action) {
        boolean result = false;
        for (Column column : this.columns) {
            if (column.scrollPane.func_231039_at__().isEmpty()) continue;
            boolean b = action.apply(column.scrollPane);
            result = b || result;
        }
        return result;
    }

    public void close() {
    }

    public String getTitle() {
        return "";
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public final void initPage(int marginH, int marginV, OverlayScreen parent) {
        this.parent = parent;
        int top = marginV;
        int left = marginH;
        int pageWidth = parent.field_230708_k_ - marginH * 2;
        int pageHeight = parent.field_230709_l_;
        for (int i = 0; i < this.columns.length; ++i) {
            Column column;
            int columnWidth = Math.max(0, Math.round(this.sizes[i] * (float)pageWidth) - 2 * this.hpad);
            this.columns[i] = column = new Column(left, top, columnWidth, pageHeight, this.hpad, this.vpad);
            left += columnWidth > 0 ? columnWidth + 2 * this.hpad : 0;
        }
        this.init(parent);
    }

    public void addElements(int x, int y, Column column, CompoundNBT settings, Consumer<Widget> consumer, Runnable callback) {
        this.addElements(x, y, column, settings, false, consumer, callback);
    }

    public void addElements(int x, int y, Column column, CompoundNBT settings, boolean deep, Consumer<Widget> consumer, Runnable callback) {
        if (Page.skip(settings)) {
            return;
        }
        AtomicInteger top = new AtomicInteger(y);
        DataUtils.streamKeys(settings).forEach(name -> {
            Widget button = this.createButton((String)name, settings, callback);
            if (button != null) {
                button.func_230991_b_(column.width);
                button.setHeight(20);
                button.field_230690_l_ = x;
                button.field_230691_m_ = top.getAndAdd(22);
                consumer.accept(button);
                this.onAddWidget(button);
            } else if (deep) {
                INBT child = settings.func_74781_a(name);
                if (child == null || child.func_74732_a() != 10) {
                    return;
                }
                if (Page.skip((CompoundNBT)child)) {
                    return;
                }
                Widget label = this.createLabel((String)name, settings);
                if (label != null) {
                    label.field_230690_l_ = x;
                    label.field_230691_m_ = top.getAndAdd(22);
                    consumer.accept(label);
                }
                this.addElements(x, top.get(), column, (CompoundNBT)child, true, consumer, callback);
            }
        });
    }

    public Widget createButton(String name, CompoundNBT value, Runnable callback) {
        INBT tag = value.func_74781_a(name);
        if (tag == null) {
            return null;
        }
        byte type = tag.func_74732_a();
        if (type == 3) {
            if (Page.isRand(name, value)) {
                return new TFRandButton(name, value).callback(callback);
            }
            if (Page.hasLimit(name, value)) {
                return new TFSlider.BoundInt(name, value).callback(callback);
            }
            return new TFSlider.Int(name, value).callback(callback);
        }
        if (type == 5) {
            if (Page.hasLimit(name, value)) {
                return new TFSlider.BoundFloat(name, value).callback(callback);
            }
            return new TFSlider.Float(name, value).callback(callback);
        }
        if (Page.hasOptions(name, value)) {
            return new TFToggle(name, value).callback(callback);
        }
        if (type == 8) {
            return new TFTextBox(name, value);
        }
        return null;
    }

    public Widget createLabel(String name, CompoundNBT settings) {
        if (settings.func_74775_l("#" + name).func_74764_b("noname")) {
            return null;
        }
        return new TFLabel(Element.getDisplayName(name, settings));
    }

    public void onAddWidget(Widget widget) {
    }

    private static boolean skip(CompoundNBT value) {
        INBT tag = value.func_74781_a("#hide");
        return tag instanceof ByteNBT && ((ByteNBT)tag).func_150290_f() == 1;
    }

    private static boolean hasOptions(String name, CompoundNBT value) {
        return value.func_74775_l('#' + name).func_74764_b("options");
    }

    private static boolean hasLimit(String name, CompoundNBT value) {
        String key = '#' + name;
        return value.func_74775_l(key).func_74764_b("limit_lower") || value.func_74775_l(key).func_74764_b("limit_upper");
    }

    private static boolean isRand(String name, CompoundNBT value) {
        return value.func_74775_l('#' + name).func_74764_b("random");
    }

    public static class Column {
        public final int left;
        public final int right;
        public final int top;
        public final int bottom;
        public final int width;
        public final int height;
        public final ScrollPane scrollPane;

        private Column(int left, int top, int width, int height, int vpad, int hpad) {
            this.left = left + vpad;
            this.right = left + width - vpad;
            this.top = top + hpad;
            this.bottom = height - hpad;
            this.width = width;
            this.height = height;
            this.scrollPane = new ScrollPane(25);
            this.scrollPane.func_230940_a_(width, height, 30, height - 30);
            this.scrollPane.func_230959_g_(this.left);
        }
    }
}

