/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.element;

import com.terraforged.mod.client.gui.element.Element;
import com.terraforged.noise.util.NoiseUtil;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public abstract class TFSlider
extends Slider
implements Slider.ISlider,
Element {
    protected final String name;
    private final CompoundNBT value;
    private final List<String> tooltip;
    private boolean lock = false;
    private Runnable callback = () -> {};

    public TFSlider(String name, CompoundNBT value, boolean decimal) {
        super(0, 0, 100, 20, (ITextComponent)new StringTextComponent(Element.getDisplayName(name, value) + ": "), (ITextComponent)new StringTextComponent(""), (double)TFSlider.min(name, value), (double)TFSlider.max(name, value), 0.0, decimal, true, b -> {});
        this.name = name;
        this.value = value;
        this.parent = this;
        this.tooltip = Element.getToolTip(name, value);
    }

    public TFSlider callback(Runnable callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    public void onChangeSliderValue(Slider slider) {
        if (!this.lock) {
            this.lock = true;
            this.onChange(slider, this.value);
            this.lock = false;
        }
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        if (this.dragging) {
            this.callback.run();
        }
        super.func_231000_a__(mouseX, mouseY);
    }

    protected abstract void onChange(Slider var1, CompoundNBT var2);

    private static float min(String name, CompoundNBT value) {
        CompoundNBT meta = value.func_74775_l('#' + name);
        return meta.func_74760_g("min");
    }

    private static float max(String name, CompoundNBT value) {
        CompoundNBT meta = value.func_74775_l('#' + name);
        return meta.func_74760_g("max");
    }

    public static class BoundInt
    extends BoundSlider {
        public BoundInt(String name, CompoundNBT value) {
            this(name, value, 1);
        }

        public BoundInt(String name, CompoundNBT value, int pad) {
            super(name, value, pad, false);
            this.setValue(value.func_74762_e(name));
            this.updateSlider();
        }

        @Override
        protected void onChange(Slider slider, CompoundNBT value) {
            int i = slider.getValueInt();
            float lower = this.getLower(value) + this.pad;
            float upper = this.getUpper(value) - this.pad;
            int val = NoiseUtil.round(NoiseUtil.clamp(i, lower, upper));
            value.func_74768_a(this.name, val);
            this.setValue(val);
            this.updateSlider();
        }
    }

    public static class BoundFloat
    extends BoundSlider {
        public BoundFloat(String name, CompoundNBT value) {
            this(name, value, 0.005f);
        }

        public BoundFloat(String name, CompoundNBT value, float pad) {
            super(name, value, pad, true);
            this.precision = 3;
            this.setValue(value.func_74760_g(name));
            this.updateSlider();
        }

        @Override
        protected void onChange(Slider slider, CompoundNBT value) {
            int i = (int)(slider.getValue() * 1000.0);
            float lower = this.getLower(value) + this.pad;
            float upper = this.getUpper(value) - this.pad;
            float val = NoiseUtil.clamp((float)i / 1000.0f, lower, upper);
            value.func_74776_a(this.name, val);
            this.setValue(val);
            this.updateSlider();
        }
    }

    public static abstract class BoundSlider
    extends TFSlider {
        protected final float pad;
        protected final String lower;
        protected final String upper;

        public BoundSlider(String name, CompoundNBT value, float defaultPad, boolean decimal) {
            super(name, value, decimal);
            CompoundNBT meta = value.func_74775_l('#' + name);
            float pad = meta.func_74760_g("pad");
            this.pad = pad < 0.0f ? defaultPad : pad;
            this.lower = meta.func_74779_i("limit_lower");
            this.upper = meta.func_74779_i("limit_upper");
        }

        protected float getLower(CompoundNBT value) {
            if (this.lower == null || this.lower.isEmpty()) {
                return (float)(this.minValue - (double)this.pad);
            }
            return value.func_74760_g(this.lower);
        }

        protected float getUpper(CompoundNBT value) {
            if (this.upper == null || this.upper.isEmpty()) {
                return (float)(this.maxValue + (double)this.pad);
            }
            return value.func_74760_g(this.upper);
        }
    }

    public static class Float
    extends TFSlider {
        public Float(String name, CompoundNBT value) {
            super(name, value, true);
            this.precision = 3;
            this.setValue(value.func_74760_g(name));
            this.updateSlider();
        }

        @Override
        protected void onChange(Slider slider, CompoundNBT value) {
            int i = (int)(slider.getValue() * 1000.0);
            float f = (float)i / 1000.0f;
            value.func_74776_a(this.name, f);
        }
    }

    public static class Int
    extends TFSlider {
        public Int(String name, CompoundNBT value) {
            super(name, value, false);
            this.setValue(value.func_74762_e(name));
            this.updateSlider();
        }

        @Override
        protected void onChange(Slider slider, CompoundNBT value) {
            value.func_74768_a(this.name, slider.getValueInt());
        }
    }
}

