/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.mod.api.chunk.column.ColumnDecorator;
import com.terraforged.mod.api.chunk.column.DecoratorContext;
import com.terraforged.mod.biome.TFBiomeContainer;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.fix.RegionFix;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.util.ChunkRegionBoundingBox;
import com.terraforged.mod.featuremanager.biome.BiomeFeature;
import com.terraforged.mod.featuremanager.biome.BiomeFeatures;
import com.terraforged.mod.profiler.watchdog.UncheckedException;
import com.terraforged.mod.profiler.watchdog.WarnTimer;
import com.terraforged.mod.profiler.watchdog.Watchdog;
import com.terraforged.mod.profiler.watchdog.WatchdogContext;
import com.terraforged.mod.util.Environment;
import java.util.List;
import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class FeatureGenerator
implements Generator.Features {
    private static final int FEATURE_STAGES = GenerationStage.Decoration.values().length;
    private static final String STRUCTURE = "Structure";
    private static final String FEATURE = "Feature";
    private final long hangTime;
    private final TFChunkGenerator generator;

    public FeatureGenerator(TFChunkGenerator generator) {
        this.generator = generator;
        this.hangTime = Watchdog.getWatchdogHangTime();
    }

    @Override
    public final void generateFeatures(WorldGenRegion region, StructureManager manager) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        IChunk chunk = region.func_212866_a_(chunkX, chunkZ);
        ChunkReader reader = this.generator.getChunkReader(chunkX, chunkZ);
        TFBiomeContainer container = TFBiomeContainer.getOrCreate(chunk, reader, this.generator.getBiomeSource());
        RegionFix regionFix = new RegionFix(region, this.generator);
        Biome biome = container.getFeatureBiome();
        try (DecoratorContext context = this.generator.getContext().decorator(chunk);){
            BlockPos pos = new BlockPos(context.blockX, 0, context.blockZ);
            this.decorate(manager, (ISeedReader)regionFix, chunk, biome, pos);
            this.postProcess(reader, container, context);
            ((ChunkPrimer)chunk).func_225548_a_(container.bakeBiomes(Environment.isVanillaBiomes(), this.generator.getContext().biomeContext));
            reader.close();
            reader.dispose();
        }
    }

    private void decorate(StructureManager manager, ISeedReader region, IChunk chunk, Biome biome, BlockPos pos) {
        try (WatchdogContext context = Watchdog.punchIn(chunk, this.generator, this.hangTime);){
            this.decorate(manager, region, chunk, biome, pos, context);
        }
    }

    private void decorate(StructureManager manager, ISeedReader region, IChunk chunk, Biome biome, BlockPos pos, WatchdogContext context) {
        SharedSeedRandom random = new SharedSeedRandom();
        long decorationSeed = random.func_202424_a(region.func_72905_C(), pos.func_177958_n(), pos.func_177952_p());
        BiomeFeatures biomeFeatures = this.generator.getFeatureManager().getFeatures(biome);
        List<List<BiomeFeature>> stagedFeatures = biomeFeatures.getFeatures();
        List<List<Structure<?>>> stagedStructures = biomeFeatures.getStructures();
        WarnTimer timer = Watchdog.getWarnTimer();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        ChunkRegionBoundingBox chunkBounds = new ChunkRegionBoundingBox(chunkX, chunkZ, 1);
        for (int stageIndex = 0; stageIndex < FEATURE_STAGES; ++stageIndex) {
            long timeStamp;
            int featureSeed = 0;
            if (stageIndex < stagedStructures.size()) {
                context.pushPhase(STRUCTURE);
                List<Structure<?>> structures = stagedStructures.get(stageIndex);
                for (int structureIndex = 0; structureIndex < structures.size(); ++structureIndex) {
                    Structure<?> structure = structures.get(structureIndex);
                    random.func_202426_b(decorationSeed, featureSeed++, stageIndex);
                    try {
                        timeStamp = timer.now();
                        context.pushIdentifier(structure.func_143025_a(), timeStamp);
                        manager.func_235011_a_(SectionPos.func_218167_a((BlockPos)pos), structure).forEach(start -> start.func_230366_a_(region, manager, (ChunkGenerator)this.generator, (Random)random, (MutableBoundingBox)chunkBounds.init((StructureStart<?>)start), chunkPos));
                        Generator.checkTime(STRUCTURE, structure.func_143025_a(), timer, timeStamp, context);
                        continue;
                    }
                    catch (Throwable t) {
                        throw new UncheckedException(STRUCTURE, structure.func_143025_a(), t);
                    }
                }
            }
            if (stageIndex >= stagedFeatures.size()) continue;
            context.pushPhase(FEATURE);
            List<BiomeFeature> features = stagedFeatures.get(stageIndex);
            for (int featureIndex = 0; featureIndex < features.size(); ++featureIndex) {
                BiomeFeature feature = features.get(featureIndex);
                random.func_202426_b(decorationSeed, featureSeed++, stageIndex);
                if (!feature.getPredicate().test(chunk, biome)) continue;
                try {
                    timeStamp = timer.now();
                    context.pushIdentifier(feature.getIdentity(), timeStamp);
                    feature.getFeature().func_242765_a(region, (ChunkGenerator)this.generator, (Random)random, pos);
                    Generator.checkTime(FEATURE, feature.getIdentity(), timer, timeStamp, context);
                    continue;
                }
                catch (Throwable t) {
                    throw new UncheckedException(FEATURE, feature.getIdentity(), t);
                }
            }
        }
    }

    private void postProcess(ChunkReader reader, TFBiomeContainer container, DecoratorContext context) {
        List<ColumnDecorator> decorators = this.generator.getPostProcessors();
        reader.iterate(context, (cell, dx, dz, ctx) -> {
            int px = ctx.blockX + dx;
            int pz = ctx.blockZ + dz;
            int py = ctx.chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, dx, dz);
            ctx.cell = cell;
            ctx.biome = container.getBiome(dx, dz);
            for (ColumnDecorator decorator : decorators) {
                decorator.decorate(ctx.chunk, (DecoratorContext)ctx, px, py, pz);
            }
        });
    }
}

