/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.surface;

import com.terraforged.engine.Seed;
import com.terraforged.mod.api.biome.surface.MaskedSurface;
import com.terraforged.mod.api.biome.surface.SurfaceContext;
import com.terraforged.mod.api.material.state.States;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import java.util.function.IntFunction;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.Heightmap;

public class StoneForestSurface
implements MaskedSurface {
    public static final int SEED_OFFSET = -2345768;
    private final Module module;
    private final BlockState dirt = (BlockState)States.DIRT.get();
    private final BlockState grass;
    private final BlockState stone = (BlockState)States.STONE.get();

    public StoneForestSurface(Seed seed) {
        this.grass = (BlockState)States.GRASS_BLOCK.get();
        IntFunction<Module> func = scale -> Source.ridge(seed.next(), scale, 4).clamp(0.7, 0.95).map(0.0, 1.0).pow(1.5).legacyTerrace(1.0, 0.25, 4, 0.25);
        this.module = func.apply(50).max(func.apply(55));
    }

    @Override
    public void buildSurface(int x, int z, int height, float mask, SurfaceContext ctx) {
        float strength = 1.0f - ctx.cell.gradient;
        float value = this.module.getValue(x, z) * mask * strength;
        int top = height + (int)(value * 50.0f);
        if (top > height) {
            for (int y = height = ctx.chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z); y < top - 1; ++y) {
                ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, y, z), this.stone, false);
            }
            ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, top, z), this.grass, false);
            ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, top - 1, z), this.dirt, false);
        }
    }
}

