/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.data;

import net.minecraft.util.math.SectionPos;

public class ChunkRenderBounds {
    public static final ChunkRenderBounds ALWAYS_FALSE = new ChunkRenderBounds(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    public final float x1;
    public final float y1;
    public final float z1;
    public final float x2;
    public final float y2;
    public final float z2;

    public ChunkRenderBounds(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public ChunkRenderBounds(SectionPos origin) {
        this.x1 = origin.func_218161_d();
        this.y1 = origin.func_218151_e();
        this.z1 = origin.func_218164_f();
        this.x2 = origin.func_218152_g() + 1;
        this.y2 = origin.func_218165_h() + 1;
        this.z2 = origin.func_218143_r() + 1;
    }

    public static class Builder {
        private int x = 0;
        private int y = 0;
        private int z = 0;

        public void addBlock(int x, int y, int z) {
            this.x |= 1 << x;
            this.y |= 1 << y;
            this.z |= 1 << z;
        }

        public ChunkRenderBounds build(SectionPos origin) {
            if ((this.x | this.y | this.z) == 0) {
                return new ChunkRenderBounds(origin);
            }
            int x1 = origin.func_218161_d() + Builder.leftBound(this.x);
            int x2 = origin.func_218161_d() + Builder.rightBound(this.x);
            int y1 = origin.func_218151_e() + Builder.leftBound(this.y);
            int y2 = origin.func_218151_e() + Builder.rightBound(this.y);
            int z1 = origin.func_218164_f() + Builder.leftBound(this.z);
            int z2 = origin.func_218164_f() + Builder.rightBound(this.z);
            return new ChunkRenderBounds((float)Math.max(x1, origin.func_218161_d()) - 0.5f, (float)Math.max(y1, origin.func_218151_e()) - 0.5f, (float)Math.max(z1, origin.func_218164_f()) - 0.5f, (float)Math.min(x2, origin.func_218152_g()) + 0.5f, (float)Math.min(y2, origin.func_218165_h()) + 0.5f, (float)Math.min(z2, origin.func_218143_r()) + 0.5f);
        }

        private static int leftBound(int i) {
            return Integer.numberOfTrailingZeros(i);
        }

        private static int rightBound(int i) {
            return 32 - Integer.numberOfLeadingZeros(i);
        }
    }
}

