/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.shader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ShaderLoader {
    public static GlShader loadShader(RenderDevice device, ShaderType type, ResourceLocation name, ShaderConstants constants) {
        return new GlShader(device, type, name, ShaderLoader.getShaderSource(ShaderLoader.getShaderPath(name)), constants);
    }

    @Deprecated
    public static GlShader loadShader(RenderDevice device, ShaderType type, ResourceLocation name, List<String> constants) {
        return new GlShader(device, type, name, ShaderLoader.getShaderSource(ShaderLoader.getShaderPath(name)), ShaderConstants.fromStringList(constants));
    }

    private static String getShaderPath(ResourceLocation name) {
        return String.format("/assets/%s/shaders/%s", name.func_110624_b(), name.func_110623_a());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getShaderSource(String path) {
        try (InputStream in = ShaderLoader.class.getResourceAsStream(path);){
            if (in == null) {
                throw new RuntimeException("Shader not found: " + path);
            }
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read shader sources", e);
        }
    }
}

