/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.utils;

import java.text.DecimalFormat;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConstructUtils {
    public static final DecimalFormat dfPercentSpec = new DecimalFormat("#.#%");

    public static String getPrefixedName(String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Non-lowercase unlocalized name detected! %s", name));
        }
        return "conarm." + name;
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation("conarm", name);
    }

    public static <T extends Block> T registerItemBlock(IForgeRegistry<Item> registry, ItemBlock itemBlock) {
        itemBlock.func_77655_b(itemBlock.func_179223_d().func_149739_a());
        ConstructUtils.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
        return (T)itemBlock.func_179223_d();
    }

    public static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        block.func_149663_c(ConstructUtils.getPrefixedName(name));
        ConstructUtils.register(registry, block, name);
        return block;
    }

    public static <T extends Item> T registerItem(IForgeRegistry<Item> registry, T item, String name) {
        item.func_77655_b(ConstructUtils.getPrefixedName(name));
        ConstructUtils.register(registry, item, name);
        return item;
    }

    private static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, T toRegister, String name) {
        ConstructUtils.register(registry, toRegister, ConstructUtils.getResource(name));
    }

    private static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, T toRegister, ResourceLocation name) {
        toRegister.setRegistryName(name);
        registry.register(toRegister);
    }
}

