/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class NBTMatchingRecipe
extends ShapedRecipes {
    private final String[][] matchingNBTs;

    public NBTMatchingRecipe(int width, int height, ItemStack[] input, String[][] matchingNBTs, ItemStack output) {
        super("rftoolsdim:nbtmatching", width, height, NBTMatchingRecipe.getIngredients(input), output);
        this.matchingNBTs = matchingNBTs;
    }

    private static NonNullList<Ingredient> getIngredients(ItemStack[] input) {
        NonNullList inputList = NonNullList.func_191197_a((int)input.length, (Object)Ingredient.field_193370_a);
        for (int i = 0; i < input.length; ++i) {
            inputList.set(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input[i]}));
        }
        return inputList;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        return super.func_77572_b(inventoryCrafting);
    }

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        for (int i = 0; i <= 3 - this.field_77576_b; ++i) {
            for (int j = 0; j <= 3 - this.field_77577_c; ++j) {
                if (this.checkMatchInternal(inventoryCrafting, i, j, true)) {
                    return true;
                }
                if (!this.checkMatchInternal(inventoryCrafting, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatchInternal(InventoryCrafting inventoryCrafting, int x, int y, boolean reversed) {
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                ItemStack itemstack1;
                int i1 = col - x;
                int j1 = row - y;
                ItemStack itemstack = ItemStack.field_190927_a;
                String[] nbt = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.field_77576_b && j1 < this.field_77577_c) {
                    int idx = reversed ? this.field_77576_b - i1 - 1 + j1 * this.field_77576_b : i1 + j1 * this.field_77576_b;
                    Ingredient ingredient = (Ingredient)this.field_77574_d.get(idx);
                    itemstack = ingredient.func_193365_a().length > 0 ? ingredient.func_193365_a()[0] : ItemStack.field_190927_a;
                    nbt = this.matchingNBTs[idx];
                }
                if ((itemstack1 = inventoryCrafting.func_70463_b(col, row)).func_190926_b() && itemstack.func_190926_b()) continue;
                if (itemstack1.func_190926_b() || itemstack.func_190926_b()) {
                    return false;
                }
                if (itemstack.func_77973_b() != itemstack1.func_77973_b()) {
                    return false;
                }
                if (itemstack.func_77960_j() != Short.MAX_VALUE && itemstack.func_77960_j() != itemstack1.func_77960_j()) {
                    return false;
                }
                NBTTagCompound compound = itemstack.func_77978_p();
                NBTTagCompound compound1 = itemstack1.func_77978_p();
                if (nbt == null) continue;
                if (compound == null && compound1 != null) {
                    return false;
                }
                if (compound != null && compound1 == null) {
                    return false;
                }
                if (compound == null) continue;
                for (String tagName : nbt) {
                    NBTBase tag = compound.func_74781_a(tagName);
                    NBTBase tag1 = compound1.func_74781_a(tagName);
                    if (tag == null && tag1 != null) {
                        return false;
                    }
                    if (tag != null && tag1 == null) {
                        return false;
                    }
                    if (tag == null || tag.equals((Object)tag1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

