/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.world;

import java.util.ArrayDeque;
import java.util.Random;
import java.util.Set;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.ModBlocks;
import mcjty.rftools.blocks.ores.DimensionalShardBlock;
import mcjty.rftools.config.GeneralConfiguration;
import mcjty.rftools.world.WorldTickHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RFToolsWorldGenerator
implements IWorldGenerator {
    public static final String RETRO_NAME = "RFToolsGen";
    public static RFToolsWorldGenerator instance = new RFToolsWorldGenerator();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world, true);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!newGen && !GeneralConfiguration.retrogen.get()) {
            return;
        }
        Set<Integer> oregen = RFTools.setup.rftoolsDimensions ? GeneralConfiguration.oregenDimensionsWithDimensions : GeneralConfiguration.oregenDimensionsWithoutDimensions;
        if (oregen.contains(world.field_73011_w.getDimension())) {
            IBlockState base;
            IBlockState ore;
            if (world.field_73011_w.getDimension() == 1) {
                ore = ModBlocks.dimensionalShardBlock.func_176223_P().func_177226_a(DimensionalShardBlock.ORETYPE, (Comparable)((Object)DimensionalShardBlock.OreType.ORE_END));
                base = Blocks.field_150377_bs.func_176223_P();
            } else if (world.field_73011_w.getDimension() == -1) {
                ore = ModBlocks.dimensionalShardBlock.func_176223_P().func_177226_a(DimensionalShardBlock.ORETYPE, (Comparable)((Object)DimensionalShardBlock.OreType.ORE_NETHER));
                base = Blocks.field_150424_aL.func_176223_P();
            } else {
                ore = ModBlocks.dimensionalShardBlock.func_176223_P();
                base = Blocks.field_150348_b.func_176223_P();
            }
            this.addOreSpawn(ore, base, world, random, chunkX * 16, chunkZ * 16, GeneralConfiguration.oreMinimumVeinSize.get(), GeneralConfiguration.oreMaximumVeinSize.get(), GeneralConfiguration.oreMaximumVeinCount.get(), GeneralConfiguration.oreMinimumHeight.get(), GeneralConfiguration.oreMaximumHeight.get());
        }
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    public void addOreSpawn(IBlockState block, IBlockState targetBlock, World world, Random random, int blockXPos, int blockZPos, int minVeinSize, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        WorldGenMinable minable = new WorldGenMinable(block, minVeinSize + random.nextInt(maxVeinSize - minVeinSize), state -> state.func_177230_c() == targetBlock.func_177230_c());
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(16);
            minable.func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    @SubscribeEvent
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound genTag = event.getData().func_74775_l(RETRO_NAME);
        if (!genTag.func_74764_b("generated")) {
            genTag.func_74757_a("generated", true);
        }
        event.getData().func_74782_a(RETRO_NAME, (NBTBase)genTag);
    }

    @SubscribeEvent
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a(RETRO_NAME);
        NBTTagList list = null;
        Pair cCoord = Pair.of((Object)event.getChunk().field_76635_g, (Object)event.getChunk().field_76647_h);
        if (tag != null) {
            boolean generated;
            boolean bl = generated = GeneralConfiguration.retrogen.get() && !tag.func_74764_b("generated");
            if (generated) {
                regen = true;
            }
        } else {
            regen = GeneralConfiguration.retrogen.get();
        }
        if (regen) {
            ArrayDeque chunks = (ArrayDeque)WorldTickHandler.chunksToGen.get(dim);
            if (chunks == null) {
                WorldTickHandler.chunksToGen.put(dim, new ArrayDeque(128));
                chunks = (ArrayDeque)WorldTickHandler.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.addLast(new WorldTickHandler.RetroChunkCoord((Pair<Integer, Integer>)cCoord, list));
                WorldTickHandler.chunksToGen.put(dim, (Object)chunks);
            }
        }
    }
}

