/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.Optional;
import java.util.function.Function;
import mcjty.lib.base.ModBase;
import mcjty.lib.proxy.IProxy;
import mcjty.rftools.ClientInfo;
import mcjty.rftools.TickOrderHandler;
import mcjty.rftools.api.screens.IScreenModuleRegistry;
import mcjty.rftools.api.teleportation.ITeleportationManager;
import mcjty.rftools.apiimpl.ScreenModuleRegistry;
import mcjty.rftools.apiimpl.TeleportationManager;
import mcjty.rftools.commands.CommandRftCfg;
import mcjty.rftools.commands.CommandRftDb;
import mcjty.rftools.commands.CommandRftShape;
import mcjty.rftools.commands.CommandRftTp;
import mcjty.rftools.items.manual.GuiRFToolsManual;
import mcjty.rftools.setup.ModSetup;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="rftools", name="RFTools", dependencies="required-after:mcjtylib_ng@[3.5.0,);before:xnet@[1.7.0,);after:forge@[14.22.0.2464,)", acceptedMinecraftVersions="[1.12,1.13)", version="7.70")
public class RFTools
implements ModBase {
    public static final String MODID = "rftools";
    public static final String VERSION = "7.70";
    public static final String MIN_FORGE_VER = "14.22.0.2464";
    public static final String MIN_MCJTYLIB_VER = "3.5.0";
    public static final String MIN_XNET_VER = "1.7.0";
    @SidedProxy(clientSide="mcjty.rftools.setup.ClientProxy", serverSide="mcjty.rftools.setup.ServerProxy")
    public static IProxy proxy;
    public static ModSetup setup;
    @Mod.Instance(value="rftools")
    public static RFTools instance;
    public static ScreenModuleRegistry screenModuleRegistry;
    public ClientInfo clientInfo = new ClientInfo();

    public String getModId() {
        return MODID;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        setup.preInit(e);
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        setup.init(e);
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        setup.postInit(e);
        proxy.postInit(e);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandRftTp());
        event.registerServerCommand((ICommand)new CommandRftShape());
        event.registerServerCommand((ICommand)new CommandRftDb());
        event.registerServerCommand((ICommand)new CommandRftCfg());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerAboutToStartEvent event) {
        TickOrderHandler.clean();
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            Optional value;
            if (message.key.equalsIgnoreCase("getApi") || message.key.equalsIgnoreCase("getTeleportationManager")) {
                value = message.getFunctionValue(ITeleportationManager.class, Void.class);
                ((Function)value.get()).apply(new TeleportationManager());
                continue;
            }
            if (!message.key.equalsIgnoreCase("getScreenModuleRegistry")) continue;
            value = message.getFunctionValue(IScreenModuleRegistry.class, Void.class);
            ((Function)value.get()).apply(screenModuleRegistry);
        }
    }

    public void openManual(EntityPlayer player, int bookIndex, String page) {
        GuiRFToolsManual.locatePage = page;
        player.openGui((Object)instance, bookIndex, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    static {
        setup = new ModSetup();
        screenModuleRegistry = new ScreenModuleRegistry();
    }
}

