/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.util;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.decoration.WorldDecoration;
import com.gildedgames.aether.api.world.decoration.WorldDecorationSimple;
import com.gildedgames.aether.api.world.generation.positioners.PositionerLevels;
import com.gildedgames.aether.api.world.generation.positioners.PositionerSurface;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherFlower;
import com.gildedgames.aether.common.world.decorations.WorldGenCaveFloorPlacer;
import com.gildedgames.aether.common.world.decorations.WorldGenFloorPlacer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class GenUtil {
    public static List<IBlockState> GENERAL_FLOWER_STATES = Lists.newArrayList((Object[])new IBlockState[]{BlocksAether.pink_swingtip.func_176223_P(), BlocksAether.green_swingtip.func_176223_P(), BlocksAether.neverbloom.func_176223_P(), BlocksAether.aether_flower.func_176203_a(BlockAetherFlower.BURSTBLOSSOM.getMeta()), BlocksAether.aether_flower.func_176203_a(BlockAetherFlower.WHITE_ROSE.getMeta()), BlocksAether.aether_flower.func_176203_a(BlockAetherFlower.PURPLE_FLOWER.getMeta()), BlocksAether.quickshoot.func_176223_P(), BlocksAether.blue_swingtip.func_176223_P()});
    public static List<IBlockState> SHROOM_STATES = Lists.newArrayList((Object[])new IBlockState[]{BlocksAether.barkshroom.func_176223_P(), BlocksAether.stoneshroom.func_176223_P()});

    public static WorldDecoration createShroomDecorations(List<IBlockState> toPickFrom) {
        WorldGenCaveFloorPlacer shroomPlacer = new WorldGenCaveFloorPlacer(random -> (IBlockState)toPickFrom.get(random.nextInt(toPickFrom.size())), 7);
        return new WorldDecorationSimple(2, 0.2f, DecorateBiomeEvent.Decorate.EventType.CUSTOM, new PositionerLevels(26, 90), shroomPlacer);
    }

    public static WorldDecoration createFlowerDecorations(Random rand, List<IBlockState> toPickFrom, List<IBlockState> mustHave) {
        int amountOfFlowerTypes = 2 + rand.nextInt(4);
        ArrayList flowerStates = Lists.newArrayList();
        for (int i = 0; i < amountOfFlowerTypes; ++i) {
            flowerStates.add(toPickFrom.get(rand.nextInt(toPickFrom.size())));
        }
        WorldGenFloorPlacer flowers = new WorldGenFloorPlacer(4, GenUtil.equalStateFetcher(), random -> {
            ArrayList returned = Lists.newArrayList();
            for (int i = 0; i < 1 + random.nextInt(amountOfFlowerTypes); ++i) {
                returned.add(flowerStates.get(random.nextInt(flowerStates.size())));
            }
            returned.addAll(mustHave);
            return returned;
        });
        return new WorldDecorationSimple(1 + rand.nextInt(6), 0.05f + rand.nextFloat() * 0.2f, DecorateBiomeEvent.Decorate.EventType.FLOWERS, new PositionerSurface(), flowers);
    }

    public static BlockPos rotate(BlockPos origin, BlockPos pos, Rotation rotation) {
        int i = pos.func_177958_n() - origin.func_177958_n();
        int j = pos.func_177956_o() - origin.func_177956_o();
        int k = pos.func_177952_p() - origin.func_177952_p();
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(origin.func_177958_n() + k, pos.func_177956_o(), origin.func_177952_p() - i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(origin.func_177958_n() - i, pos.func_177956_o(), origin.func_177952_p() + i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(origin.func_177958_n() - i, pos.func_177956_o(), origin.func_177952_p() - k);
            }
        }
        return pos;
    }

    public static WorldGenFloorPlacer.StateFetcher equalStateFetcher() {
        return (random, states) -> (IBlockState)states.get(random.nextInt(states.size()));
    }

    public static Function<Random, List<IBlockState>> standardStateDefiner(IBlockState ... states) {
        return random -> Lists.newArrayList((Object[])states);
    }
}

