/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.templates.conditions;

import com.gildedgames.aether.api.util.TemplateUtil;
import com.gildedgames.aether.api.world.templates.PlacementConditionTemplate;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.gildedgames.orbis.lib.util.mc.BlockUtil;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.Template;

public class ReplaceablePlacementCondition
implements PlacementConditionTemplate {
    private final boolean isCriticalWithCheck;
    private final List<Material> acceptedMaterials;

    public ReplaceablePlacementCondition(boolean isCriticalWithCheck, Material ... acceptedMaterials) {
        this.isCriticalWithCheck = isCriticalWithCheck;
        this.acceptedMaterials = Lists.newArrayList((Object[])acceptedMaterials);
    }

    @Override
    public boolean canPlace(Template template, IBlockAccessExtended world, BlockPos placedAt, Template.BlockInfo block) {
        if (block.field_186243_b.func_177230_c() != Blocks.field_189881_dj) {
            if (!world.canAccess(block.field_186242_a)) {
                return false;
            }
            IBlockState state = world.func_180495_p(block.field_186242_a);
            if ((BlockUtil.isSolid((IBlockState)block.field_186243_b) || block.field_186243_b.func_185904_a() == Material.field_151567_E || block.field_186243_b == Blocks.field_150350_a.func_176223_P()) && (TemplateUtil.isReplaceable(world, block.field_186242_a) || this.acceptedMaterials.contains(state.func_185904_a()))) {
                return true;
            }
            if ((!this.isCriticalWithCheck ? block.field_186243_b.func_177230_c() == state.func_177230_c() : block.field_186243_b == state) || this.acceptedMaterials.contains(state.func_185904_a())) {
                return true;
            }
            return world.func_175623_d(block.field_186242_a);
        }
        return true;
    }

    @Override
    public boolean canPlaceCheckAll(Template template, IBlockAccessExtended world, BlockPos placedAt, List<Template.BlockInfo> blocks) {
        return true;
    }
}

