/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.templates;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.util.TemplateUtil;
import com.gildedgames.aether.api.world.generation.BlockRotationProcessorExtended;
import com.gildedgames.aether.api.world.templates.ITemplateProcessorExtended;
import com.gildedgames.aether.api.world.templates.PlacementConditionTemplate;
import com.gildedgames.aether.api.world.templates.TemplateDefinition;
import com.gildedgames.aether.api.world.templates.TemplateLoc;
import com.gildedgames.aether.common.blocks.multiblock.BlockMultiDummy;
import com.gildedgames.aether.common.blocks.multiblock.BlockMultiDummyHalf;
import com.gildedgames.aether.common.entities.tiles.TileEntityWildcard;
import com.gildedgames.aether.common.entities.tiles.multiblock.TileEntityMultiblockController;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class TemplatePrimer {
    public static boolean canGenerate(IBlockAccessExtended blockAccess, TemplateDefinition def, TemplateLoc loc) {
        BlockPos pos = loc.getPos();
        if (loc.isCentered()) {
            pos = TemplateUtil.getCenteredPos(def, loc);
        }
        StructureBoundingBox bb = TemplateUtil.getBoundingBoxFromTemplate(def, loc);
        if (bb.field_78894_e > 256) {
            return false;
        }
        List info = def.getTemplate().field_186270_a;
        List<Template.BlockInfo> infoTransformed = TemplatePrimer.getBlocks(info, pos, loc.getSettings(), def.getTemplate());
        for (Template.BlockInfo block : infoTransformed) {
            for (PlacementConditionTemplate condition : def.getConditions()) {
                if (blockAccess.canAccess(pos) && condition.canPlace(def.getTemplate(), blockAccess, pos, block)) continue;
                return false;
            }
        }
        for (PlacementConditionTemplate condition : def.getConditions()) {
            if (condition.canPlaceCheckAll(def.getTemplate(), blockAccess, pos, infoTransformed)) continue;
            return false;
        }
        return true;
    }

    public static void generateTemplate(IBlockAccessExtended blockAccess, TemplateDefinition def, TemplateLoc loc) {
        BlockPos pos = loc.getPos();
        if (loc.isCentered()) {
            pos = TemplateUtil.getCenteredPos(def, loc);
        }
        BlockRotationProcessorExtended processor = new BlockRotationProcessorExtended(pos, loc.getSettings());
        TemplatePrimer.populateAll(def.getTemplate(), blockAccess, pos, processor, loc.getSettings());
    }

    public static List<Template.BlockInfo> getBlocks(List<Template.BlockInfo> blockInfo, BlockPos pos, PlacementSettings settings, Template template) {
        ArrayList newInfo = Lists.newArrayList();
        for (Template.BlockInfo info : blockInfo) {
            BlockPos blockpos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)info.field_186242_a).func_177971_a((Vec3i)pos);
            newInfo.add(new Template.BlockInfo(blockpos, info.field_186243_b, info.field_186244_c));
        }
        return newInfo;
    }

    public static List<BlockPos> getBlockPos(List<Template.BlockInfo> blockInfo, BlockPos pos, PlacementSettings settings) {
        ArrayList blockPos = Lists.newArrayList();
        for (Template.BlockInfo info : blockInfo) {
            BlockPos blockpos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)info.field_186242_a).func_177971_a((Vec3i)pos);
            blockPos.add(blockpos);
        }
        return blockPos;
    }

    public static void populateAll(Template template, IBlockAccessExtended blockAccess, BlockPos pos, @Nullable ITemplateProcessorExtended processor, PlacementSettings settings) {
        List blocks = template.field_186270_a;
        if (!blocks.isEmpty() && template.func_186259_a().func_177958_n() >= 1 && template.func_186259_a().func_177956_o() >= 1 && template.func_186259_a().func_177952_p() >= 1) {
            Block block = settings.func_186219_f();
            StructureBoundingBox bb = settings.func_186213_g();
            for (Template.BlockInfo template$blockinfo : blocks) {
                TileEntity tileentity2;
                TileEntity tileentity;
                IBlockState iblockstate;
                IBlockState iblockstate1;
                BlockPos blockpos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)template$blockinfo.field_186242_a).func_177971_a((Vec3i)pos);
                Template.BlockInfo template$blockinfo1 = processor != null ? processor.processBlock(blockAccess, blockpos, template$blockinfo) : template$blockinfo;
                if (template$blockinfo1 == null) continue;
                Block block1 = template$blockinfo1.field_186243_b.func_177230_c();
                if (block != null && block == block1 || settings.func_186227_h() && block1 == Blocks.field_185779_df || bb != null && !bb.func_175898_b((Vec3i)blockpos) || (iblockstate1 = (iblockstate = template$blockinfo1.field_186243_b.func_185902_a(settings.func_186212_b())).func_185907_a(settings.func_186215_c())).func_177230_c() instanceof BlockMultiDummy || iblockstate1.func_177230_c() instanceof BlockMultiDummyHalf) continue;
                if (iblockstate1.func_177230_c() == BlocksAether.wildcard) {
                    TileEntityWildcard wildcard = new TileEntityWildcard();
                    if (blockAccess.getWorld() == null) continue;
                    World world = blockAccess.getWorld();
                    wildcard.func_145834_a(world);
                    template$blockinfo1.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                    template$blockinfo1.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                    template$blockinfo1.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                    wildcard.func_145839_a(template$blockinfo1.field_186244_c);
                    wildcard.func_189668_a(settings.func_186212_b());
                    wildcard.func_189667_a(settings.func_186215_c());
                    wildcard.onSchematicGeneration(blockAccess, world.field_73012_v);
                    continue;
                }
                if (template$blockinfo1.field_186244_c != null && (tileentity = blockAccess.func_175625_s(blockpos)) != null && tileentity instanceof IInventory) {
                    ((IInventory)tileentity).func_174888_l();
                }
                if (!blockAccess.setBlockState(blockpos, iblockstate1, 18) || template$blockinfo1.field_186244_c == null || (tileentity2 = blockAccess.func_175625_s(blockpos)) == null) continue;
                template$blockinfo1.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                template$blockinfo1.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                template$blockinfo1.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                tileentity2.func_145839_a(template$blockinfo1.field_186244_c);
                tileentity2.func_189668_a(settings.func_186212_b());
                tileentity2.func_189667_a(settings.func_186215_c());
                tileentity2.func_70296_d();
                if (!(tileentity2 instanceof TileEntityMultiblockController)) continue;
                TileEntityMultiblockController controller = (TileEntityMultiblockController)tileentity2;
                controller.rebuild();
            }
            for (Template.BlockInfo template$blockinfo2 : blocks) {
                TileEntity tileentity1;
                if (block != null && block == template$blockinfo2.field_186243_b.func_177230_c()) continue;
                BlockPos blockpos1 = Template.func_186266_a((PlacementSettings)settings, (BlockPos)template$blockinfo2.field_186242_a).func_177971_a((Vec3i)pos);
                if (bb != null && !bb.func_175898_b((Vec3i)blockpos1)) continue;
                if (blockAccess.getWorld() != null) {
                    blockAccess.getWorld().func_175722_b(blockpos1, template$blockinfo2.field_186243_b.func_177230_c(), false);
                }
                if (template$blockinfo2.field_186244_c == null || (tileentity1 = blockAccess.func_175625_s(blockpos1)) == null) continue;
                tileentity1.func_70296_d();
            }
            if (!settings.func_186221_e() && blockAccess.getWorld() != null) {
                TemplatePrimer.addEntitiesToWorld(template, blockAccess.getWorld(), pos, settings.func_186212_b(), settings.func_186215_c(), bb);
            }
        }
    }

    private static void addEntitiesToWorld(Template template, World worldIn, BlockPos pos, Mirror mirrorIn, Rotation rotationIn, @Nullable StructureBoundingBox aabb) {
        List entities = template.field_186271_b;
        for (Template.EntityInfo template$entityinfo : entities) {
            Entity entity;
            BlockPos blockpos = TemplatePrimer.transformedBlockPos(template$entityinfo.field_186248_b, mirrorIn, rotationIn).func_177971_a((Vec3i)pos);
            if (aabb != null && !aabb.func_175898_b((Vec3i)blockpos)) continue;
            NBTTagCompound nbttagcompound = template$entityinfo.field_186249_c;
            Vec3d vec3d = TemplatePrimer.transformedVec3d(template$entityinfo.field_186247_a, mirrorIn, rotationIn);
            Vec3d vec3d1 = vec3d.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72450_a));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72448_b));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72449_c));
            nbttagcompound.func_74782_a("Pos", (NBTBase)nbttaglist);
            nbttagcompound.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldIn);
            }
            catch (Exception var15) {
                entity = null;
            }
            if (entity == null) continue;
            float f = entity.func_184217_a(mirrorIn);
            entity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += entity.field_70177_z - entity.func_184229_a(rotationIn), entity.field_70125_A);
            worldIn.func_72838_d(entity);
        }
    }

    public static BlockPos transformedBlockPos(BlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(k, j, -i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-k, j, i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos;
    }

    private static Vec3d transformedVec3d(Vec3d vec, Mirror mirrorIn, Rotation rotationIn) {
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(d2, d1, 1.0 - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - d2, d1, d0);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - d0, d1, 1.0 - d2);
            }
        }
        return flag ? new Vec3d(d0, d1, d2) : vec;
    }
}

