/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.templates;

import com.gildedgames.aether.api.util.TemplateUtil;
import com.gildedgames.aether.api.world.templates.PostPlacementTemplate;
import com.gildedgames.aether.api.world.templates.TemplateDefinition;
import com.gildedgames.aether.api.world.templates.TemplateLoc;
import com.gildedgames.aether.common.world.templates.TemplatePrimer;
import com.gildedgames.orbis.lib.processing.BlockAccessExtendedWrapper;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.world.World;

public class TemplatePlacer {
    public static final Rotation[] ROTATIONS = Rotation.values();
    private static final List<IBlockAccessExtended> blockAccessList = Lists.newArrayList();

    public static Rotation getRandomRotation(Random rand) {
        return ROTATIONS[rand.nextInt(ROTATIONS.length)];
    }

    public static boolean place(World placeWith, TemplateDefinition def, TemplateLoc loc, Random rand) {
        BlockAccessExtendedWrapper chosen = null;
        for (IBlockAccessExtended access : blockAccessList) {
            if (access.getWorld() != placeWith) continue;
            chosen = access;
            break;
        }
        if (chosen == null) {
            chosen = new BlockAccessExtendedWrapper(placeWith);
            blockAccessList.add((IBlockAccessExtended)chosen);
        }
        return TemplatePlacer.place((IBlockAccessExtended)chosen, def, loc, rand);
    }

    public static boolean place(IBlockAccessExtended placeWith, TemplateDefinition def, TemplateLoc loc, Random rand) {
        boolean result;
        Rotation rotation = def.hasRandomRotation() ? ROTATIONS[rand.nextInt(ROTATIONS.length)] : ROTATIONS[0];
        loc.getSettings().func_186220_a(rotation);
        TemplateLoc before = loc.clone();
        if (loc.isCentered()) {
            loc.set(TemplateUtil.getCenteredPos(def, loc));
        }
        if (result = TemplatePrimer.canGenerate(placeWith, def, before)) {
            TemplatePrimer.generateTemplate(placeWith, def, before);
            if (placeWith.getWorld() != null) {
                for (PostPlacementTemplate post : def.getPostPlacements()) {
                    post.postGenerate(placeWith.getWorld(), rand, loc);
                }
            }
        }
        return result;
    }

    public static boolean canPlace(IBlockAccessExtended placeWith, TemplateDefinition def, TemplateLoc loc, Random rand) {
        Rotation rotation = def.hasRandomRotation() ? ROTATIONS[rand.nextInt(ROTATIONS.length)] : ROTATIONS[0];
        loc.getSettings().func_186220_a(rotation);
        if (loc.isCentered()) {
            loc.set(TemplateUtil.getCenteredPos(def, loc));
        }
        return TemplatePrimer.canGenerate(placeWith, def, loc);
    }
}

