/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.templates;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class TemplatePipeline {
    private final List<TemplateProgress> scheduledTemplates = Collections.synchronizedList(Lists.newArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void constructChunk(World world, int chunkX, int chunkZ) {
        ArrayList toRemove = Lists.newArrayList();
        List<TemplateProgress> list = this.scheduledTemplates;
        synchronized (list) {
            ChunkPos pos = new ChunkPos(chunkX, chunkZ);
            for (TemplateProgress template : this.scheduledTemplates) {
                template.construct(world, pos);
                if (!template.isFinishedConstructing()) continue;
                toRemove.add(template);
            }
        }
        this.scheduledTemplates.removeAll(toRemove);
    }

    public void scheduleTemplate(Template template, BlockPos pos) {
        this.scheduleTemplate(new TemplateProgress(template, pos));
    }

    public void scheduleTemplate(Template template, BlockPos pos, Runnable postConstuction) {
        this.scheduleTemplate(new TemplateProgress(template, pos, postConstuction));
    }

    private void scheduleTemplate(TemplateProgress progress) {
        this.scheduledTemplates.add(progress);
    }

    private static class TemplateProgress {
        private int chunksLeft;
        private final Template template;
        private final BlockPos pos;
        private final List<ChunkPos> chunksDone = Lists.newArrayList();
        private Runnable postConstruction;

        protected TemplateProgress(Template template, BlockPos pos) {
            this.pos = pos;
            this.template = template;
            int chunkX = template.func_186259_a().func_177958_n() >> 4;
            int chunkZ = template.func_186259_a().func_177952_p() >> 4;
            this.chunksLeft = chunkX * chunkZ + chunkX + chunkZ;
        }

        protected TemplateProgress(Template template, BlockPos pos, Runnable postConstruction) {
            this(template, pos);
            this.postConstruction = postConstruction;
        }

        public void construct(World world, ChunkPos pos) {
            if (!this.chunksDone.contains(pos)) {
                PlacementSettings settings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(null).func_186225_a(null).func_186226_b(false);
                this.template.func_186253_b(world, this.pos, settings);
                this.chunksDone.add(pos);
                --this.chunksLeft;
                if (this.isFinishedConstructing()) {
                    this.postConstruction.run();
                }
            }
        }

        public boolean isFinishedConstructing() {
            return this.chunksLeft <= 0;
        }
    }
}

