/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.spawning;

import com.gildedgames.aether.api.entity.spawning.EntitySpawn;
import com.gildedgames.aether.api.entity.spawning.ISpawningInfo;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.world.spawn.ISpawnArea;
import com.gildedgames.aether.api.world.spawn.ISpawnAreaManager;
import com.gildedgames.aether.api.world.spawn.ISpawnEntry;
import com.gildedgames.aether.api.world.spawn.ISpawnHandler;
import com.gildedgames.aether.api.world.spawn.conditions.IConditionPosition;
import com.gildedgames.aether.api.world.spawn.conditions.IConditionWorld;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.world.spawning.SpawnAreaManager;
import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.world.data.IWorldData;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SpawnHandler
implements ISpawnHandler {
    private final String uniqueID;
    private final List<IConditionWorld> worldConditions = Lists.newArrayList();
    private final List<IConditionPosition> posConditions = Lists.newArrayList();
    private final List<ISpawnEntry> entries = Lists.newArrayList();
    private ISpawnAreaManager access;
    private int targetEntityCountPerArea;
    private int chunkArea = 1;
    private int updateFrequencyInTicks = 20;

    public SpawnHandler(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public static boolean isNotColliding(EntityLiving.SpawnPlacementType placementType, World world, Entity entity) {
        return (placementType == EntityLiving.SpawnPlacementType.IN_AIR || WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)placementType, (World)world, (BlockPos)entity.func_180425_c())) && world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && world.func_72917_a(entity.func_174813_aQ(), entity);
    }

    @Override
    public void init(World world) {
        this.access = new SpawnAreaManager(world, this);
        OrbisLib.services().getWorldDataManager(world).register((IWorldData)this.access);
    }

    @Override
    public String getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public SpawnHandler targetEntityCountPerArea(int targetEntityCountPerArea) {
        this.targetEntityCountPerArea = targetEntityCountPerArea;
        return this;
    }

    @Override
    public SpawnHandler chunkArea(int chunkArea) {
        this.chunkArea = chunkArea;
        return this;
    }

    @Override
    public SpawnHandler updateFrequencyInTicks(int updateFrequencyInTicks) {
        this.updateFrequencyInTicks = updateFrequencyInTicks;
        return this;
    }

    @Override
    public <T extends IConditionWorld> SpawnHandler addWorldCondition(T condition) {
        this.worldConditions.add(condition);
        return this;
    }

    @Override
    public <T extends IConditionPosition> SpawnHandler condition(T condition) {
        this.posConditions.add(condition);
        return this;
    }

    @Override
    public void addEntry(ISpawnEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public void tick() {
        this.access.tick();
        World world = this.access.getWorld();
        if (this.updateFrequencyInTicks != 0 && world.func_72820_D() % (long)this.updateFrequencyInTicks != 0L) {
            return;
        }
        for (IConditionWorld condition : this.worldConditions) {
            if (condition.isMet(world)) continue;
            return;
        }
        try {
            this.checkAndSpawnEntries(this.access);
        }
        catch (Exception e) {
            AetherCore.LOGGER.warn("Failed to check and spawn entries", (Throwable)e);
        }
    }

    @Override
    public int getChunkArea() {
        return this.chunkArea;
    }

    @Override
    public void onLivingDeath(LivingDeathEvent event) {
        this.access.onLivingDeath(event);
    }

    private ISpawnEntry getWeightedEntry() {
        int maxRoll = 0;
        ArrayList table = Lists.newArrayList();
        for (ISpawnEntry entry : this.entries) {
            table.add(entry);
            maxRoll = (int)((float)maxRoll + entry.getRarityWeight());
        }
        if (table.size() == 0) {
            return null;
        }
        int roll = (int)(Math.random() * (double)maxRoll);
        for (ISpawnEntry entry : table) {
            if ((float)roll < entry.getRarityWeight()) {
                return entry;
            }
            roll = (int)((float)roll - entry.getRarityWeight());
        }
        return null;
    }

    private void checkAndSpawnEntries(ISpawnAreaManager manager) throws ReflectiveOperationException {
        IEntityLivingData livingData = null;
        int areaInBlocks = this.chunkArea * 16;
        block0: for (ISpawnArea area : manager.getLoaded()) {
            ISpawnEntry entry;
            while (area.getEntityCount() < this.targetEntityCountPerArea && (entry = this.getWeightedEntry()) != null) {
                int dif = entry.getMaxGroupSize() - entry.getMinGroupSize();
                int randSize = dif > 0 ? manager.getWorld().field_73012_v.nextInt(dif) : 0;
                int groupSize = entry.getMinGroupSize() + randSize;
                if (area.getEntityCount() + groupSize > this.targetEntityCountPerArea) continue block0;
                int minX = area.getMinChunkPos().field_77276_a * 16;
                int minZ = area.getMinChunkPos().field_77275_b * 16;
                int groupPosX = minX + manager.getWorld().field_73012_v.nextInt(areaInBlocks);
                int groupPosZ = minZ + manager.getWorld().field_73012_v.nextInt(areaInBlocks);
                int attempts = 0;
                int MAX_ATTEMPTS = 100;
                block2: for (int count = 0; count < groupSize; ++count) {
                    int scatterX = (manager.getWorld().field_73012_v.nextBoolean() ? 1 : -1) * (1 + manager.getWorld().field_73012_v.nextInt(entry.getPositionSelector().getScatter(manager.getWorld())));
                    int scatterZ = (manager.getWorld().field_73012_v.nextBoolean() ? 1 : -1) * (1 + manager.getWorld().field_73012_v.nextInt(entry.getPositionSelector().getScatter(manager.getWorld())));
                    int posX = MathHelper.func_76141_d((float)(groupPosX + scatterX));
                    int posZ = MathHelper.func_76141_d((float)(groupPosZ + scatterZ));
                    if (!manager.getWorld().func_175667_e(new BlockPos(posX, 0, posZ))) {
                        if (attempts >= MAX_ATTEMPTS) continue;
                        ++attempts;
                        --count;
                        continue;
                    }
                    int posY = entry.getPositionSelector().getPosY(manager.getWorld(), posX, posZ);
                    BlockPos spawnAt = new BlockPos(posX, posY, posZ);
                    if (manager.getWorld().func_175636_b((double)posX, (double)posY, (double)posZ, 24.0)) {
                        if (attempts >= MAX_ATTEMPTS) continue;
                        ++attempts;
                        --count;
                        continue;
                    }
                    for (IConditionPosition condition : this.posConditions) {
                        if (condition.isMet(manager.getWorld(), spawnAt, spawnAt.func_177977_b())) continue;
                        if (attempts >= MAX_ATTEMPTS) continue block2;
                        ++attempts;
                        --count;
                        continue block2;
                    }
                    for (IConditionPosition condition : entry.getConditions()) {
                        if (condition.isMet(manager.getWorld(), spawnAt, spawnAt.func_177977_b())) continue;
                        if (attempts >= MAX_ATTEMPTS) continue block2;
                        ++attempts;
                        --count;
                        continue block2;
                    }
                    Constructor<? extends Entity> constructor = entry.getEntityClass().getConstructor(World.class);
                    Entity entity = constructor.newInstance(manager.getWorld());
                    entity.func_70012_b((double)((float)posX + 0.5f), (double)posY, (double)((float)posZ + 0.5f), manager.getWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof EntityLivingBase) {
                        EntityLivingBase entityliving = (EntityLivingBase)entity;
                        entityliving.field_70759_as = entityliving.field_70177_z;
                        entityliving.field_70761_aq = entityliving.field_70177_z;
                    }
                    if (SpawnHandler.isNotColliding(entry.getPlacementType(), manager.getWorld(), entity)) {
                        EntityLiving living;
                        if (entity instanceof EntityLiving && !ForgeEventFactory.doSpecialSpawn((EntityLiving)(living = (EntityLiving)entity), (World)manager.getWorld(), (float)posX, (float)posY, (float)posZ, null)) {
                            living.func_180482_a(manager.getWorld().func_175649_E(new BlockPos((Entity)living)), null);
                        }
                        ISpawningInfo info = (ISpawningInfo)entity.getCapability(CapabilitiesAether.ENTITY_SPAWNING_INFO, null);
                        info.setSpawnArea(new EntitySpawn(this.uniqueID, manager.getWorld().field_73011_w.getDimension(), area.getAreaX(), area.getAreaZ()));
                        area.addToEntityCount(1);
                        manager.getWorld().func_72838_d(entity);
                        if (manager.getWorld() instanceof WorldServer) {
                            manager.getWorld().func_72866_a(entity, true);
                        }
                        if (!(entity instanceof EntityLiving)) continue;
                        livingData = ((EntityLiving)entity).func_180482_a(manager.getWorld().func_175649_E(new BlockPos(entity)), livingData);
                        continue;
                    }
                    if (attempts < MAX_ATTEMPTS) {
                        ++attempts;
                        --count;
                    }
                    entity.func_70106_y();
                }
                if (attempts < MAX_ATTEMPTS) continue;
                continue block0;
            }
        }
    }
}

