/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.spawning;

import com.gildedgames.aether.api.entity.spawning.EntitySpawn;
import com.gildedgames.aether.api.entity.spawning.ISpawningInfo;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.world.spawn.ISpawnArea;
import com.gildedgames.aether.api.world.spawn.ISpawnAreaManager;
import com.gildedgames.aether.api.world.spawn.ISpawnHandler;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.world.spawning.SpawnArea;
import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.util.ChunkMap;
import com.gildedgames.orbis.lib.world.data.IWorldData;
import com.gildedgames.orbis.lib.world.data.IWorldDataManager;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SpawnAreaManager
implements ISpawnAreaManager {
    private final IWorldDataManager dataManager;
    private final ChunkMap<ISpawnArea> loadedAreas = new ChunkMap();
    private final HashSet<ISpawnArea> dirty = new HashSet();
    private final World world;
    private final ISpawnHandler handler;

    public SpawnAreaManager(World world, ISpawnHandler handler) {
        this.world = world;
        this.handler = handler;
        this.dataManager = OrbisLib.services().getWorldDataManager(world);
    }

    private boolean isLoaded(int chunkX, int chunkZ) {
        return this.loadedAreas.containsKey(chunkX, chunkZ);
    }

    private ISpawnArea loadArea(int areaX, int areaZ) {
        if (this.isLoaded(areaX, areaZ)) {
            return this.getLoadedArea(areaX, areaZ);
        }
        ISpawnArea area = this.fetchArea(areaX, areaZ);
        if (area == null) {
            area = new SpawnArea(this.handler.getChunkArea(), areaX, areaZ);
            area.markDirty();
        }
        this.loadedAreas.put(areaX, areaZ, (Object)area);
        return area;
    }

    /*
     * Exception decompiling
     */
    private ISpawnArea fetchArea(int areaX, int areaZ) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void tick() {
        for (ISpawnArea area : this.getLoaded()) {
            area.setInPlayersRenderDistance(false);
        }
        for (EntityPlayer player : this.world.field_73010_i) {
            int chunkX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
            int chunkZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
            int centerAreaX = chunkX / this.handler.getChunkArea();
            int centerAreaZ = chunkZ / this.handler.getChunkArea();
            for (int areaX = centerAreaX - 1; areaX <= centerAreaX + 1; ++areaX) {
                for (int areaZ = centerAreaZ - 1; areaZ <= centerAreaZ + 1; ++areaZ) {
                    ISpawnArea area = this.loadArea(areaX, areaZ);
                    area.setInPlayersRenderDistance(true);
                }
            }
        }
        ArrayList areasToRemove = Lists.newArrayList();
        for (ISpawnArea area : this.getLoaded()) {
            if (!area.hasPlayerInside()) {
                areasToRemove.add(area);
            }
            if (!area.isDirty()) continue;
            this.dirty.add(area);
        }
        for (ISpawnArea area : areasToRemove) {
            this.loadedAreas.remove(area.getAreaX(), area.getAreaZ());
        }
    }

    @Override
    public Collection<ISpawnArea> getLoaded() {
        return this.loadedAreas.getValues();
    }

    private String createAreaID(int areaX, int areaZ) {
        return this.handler.getUniqueID() + "/" + areaX + "_" + areaZ + ".nbt";
    }

    public ResourceLocation getName() {
        return AetherCore.getResource("spawn_areas");
    }

    public void flush() {
        for (ISpawnArea area : this.dirty) {
            String areaID = this.createAreaID(area.getAreaX(), area.getAreaZ());
            NBTTagCompound tag = (NBTTagCompound)area.serializeNBT();
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                try (DataOutputStream dataOut = new DataOutputStream(stream);){
                    CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)dataOut);
                }
                stream.flush();
                this.dataManager.writeBytes((IWorldData)this, areaID, stream.toByteArray());
            }
            catch (IOException e) {
                AetherCore.LOGGER.warn("Failed to write spawn area", (Throwable)e);
            }
            area.markClean();
        }
        this.dirty.clear();
    }

    @Override
    public ISpawnArea getLoadedArea(int areaX, int areaZ) {
        return (ISpawnArea)this.loadedAreas.get(areaX, areaZ);
    }

    @Override
    public void onLivingDeath(LivingDeathEvent event) {
        ISpawningInfo spawningInfo = (ISpawningInfo)event.getEntityLiving().getCapability(CapabilitiesAether.ENTITY_SPAWNING_INFO, null);
        EntitySpawn area = spawningInfo.getSpawnArea();
        if (area == null) {
            return;
        }
        if (area.getSpawnHandlerUniqueID().equals(this.handler.getUniqueID())) {
            ISpawnArea fetchedArea = this.fetchArea(area.getAreaX(), area.getAreaZ());
            fetchedArea.addToEntityCount(-1);
        }
    }

    public class Storage
    implements Capability.IStorage<SpawnAreaManager> {
        @Nullable
        public NBTBase writeNBT(Capability<SpawnAreaManager> capability, SpawnAreaManager instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<SpawnAreaManager> capability, SpawnAreaManager instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

