/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.preparation.mask;

import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.common.world.preparation.mask.ChunkMask;
import com.gildedgames.aether.common.world.preparation.mask.ChunkMaskSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BitArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ChunkDataContainer {
    private final SegmentStorage[] segments = new SegmentStorage[16];
    private final HashMap<BlockPos, TileEntity> tileEntities = new HashMap();
    private final ArrayList<Entity> entities = new ArrayList();
    private final int chunkX;
    private final int chunkZ;
    private final boolean hasSkylight;
    private Biome[] biomesForGeneration;

    public ChunkDataContainer(int chunkX, int chunkZ, boolean hasSkylight) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.hasSkylight = hasSkylight;
    }

    public IBlockState getBlockState(BlockPos pos) {
        return this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IBlockState getBlockState(int x, int y, int z) {
        SegmentStorage segment = this.segments[y >> 4];
        if (segment == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return segment.blockStorage.func_177485_a(x, y & 0xF, z);
    }

    public void setBlockState(int x, int y, int z, IBlockState state) {
        SegmentStorage segment = this.segments[y >> 4];
        if (segment == null) {
            this.segments[y >> 4] = segment = new SegmentStorage((y >> 4) * 16, this.hasSkylight);
        }
        segment.blockStorage.func_177484_a(x, y & 0xF, z, state);
        ((SegmentStorage)segment).opacity[x << 8 | z << 4 | y & 0xF] = (byte)state.func_185891_c();
    }

    private int getBlockOpacity(int x, int y, int z) {
        SegmentStorage segment = this.segments[y >> 4];
        if (segment == null) {
            return 0;
        }
        return Byte.toUnsignedInt(segment.opacity[x << 8 | z << 4 | y & 0xF]);
    }

    public void setBlockState(BlockPos pos, IBlockState state) {
        this.setBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state);
    }

    public TileEntity getTileEntity(BlockPos pos) {
        return this.tileEntities.get(pos);
    }

    public void setTileEntity(BlockPos pos, TileEntity entity) {
        if (entity == null) {
            this.tileEntities.remove(pos);
        } else {
            entity.func_174878_a(pos);
            this.tileEntities.put(pos, entity);
        }
    }

    public static ChunkDataContainer createFromMask(World world, ChunkMask mask, IChunkMaskTransformer transformer, int chunkX, int chunkZ) {
        ChunkDataContainer container = new ChunkDataContainer(chunkX, chunkZ, world.field_73011_w.func_191066_m());
        BlockStateCacher cacher = new BlockStateCacher(transformer);
        for (int chunkY = 0; chunkY < 32; ++chunkY) {
            ChunkMaskSegment src = mask.getSegment(chunkY);
            if (src == null) continue;
            SegmentStorage dest = container.segments[chunkY >> 1];
            if (dest == null) {
                container.segments[chunkY >> 1] = dest = new SegmentStorage(chunkY >> 1 << 4, world.field_73011_w.func_191066_m());
            }
            ExtendedBlockStorage blockStorage = dest.blockStorage;
            BitArray bitArray = blockStorage.field_177488_d.field_186021_b;
            cacher.update(blockStorage.field_177488_d);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int y = 0;
                    int y2 = (chunkY & 1) * 8;
                    while (y < 8) {
                        int block = src.getBlock(x, y, z);
                        if (block != 0) {
                            int key = cacher.getValue(transformer, block);
                            ((SegmentStorage)dest).opacity[x << 8 | z << 4 | y2] = 127;
                            bitArray.func_188141_a(y2 << 8 | z << 4 | x, key);
                            ++blockStorage.field_76682_b;
                        }
                        ++y;
                        ++y2;
                    }
                }
            }
        }
        return container;
    }

    public Chunk createChunk(World world, int chunkX, int chunkZ) {
        Chunk chunk = new Chunk(world, chunkX, chunkZ);
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            SegmentStorage segment = this.segments[chunkY];
            if (segment == null) continue;
            chunk.func_76587_i()[chunkY] = segment.blockStorage;
        }
        for (TileEntity tileEntity : this.tileEntities.values()) {
            chunk.func_177426_a(tileEntity.func_174877_v(), tileEntity);
        }
        for (Entity entity : this.entities) {
            chunk.func_76612_a(entity);
        }
        this.biomesForGeneration = world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        this.prepareChunkLighting(world, chunk);
        return chunk;
    }

    private void prepareChunkLighting(World world, Chunk chunk) {
        int maxY = chunk.func_76625_h();
        chunk.field_82912_p = Integer.MAX_VALUE;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.field_76638_b[x + (z << 4)] = -999;
                for (int y = maxY + 16; y > 0; --y) {
                    if (this.getBlockOpacity(x, y - 1, z) == 0) continue;
                    chunk.field_76634_f[z << 4 | x] = y;
                    if (y >= chunk.field_82912_p) break;
                    chunk.field_82912_p = y;
                    break;
                }
                if (!world.field_73011_w.func_191066_m()) continue;
                int light = 15;
                int y2 = maxY + 16 - 1;
                do {
                    ExtendedBlockStorage extendedblockstorage;
                    int opacity;
                    if ((opacity = this.getBlockOpacity(x, y2, z)) == 0 && light != 15) {
                        opacity = 1;
                    }
                    if ((light -= opacity) <= 0 || (extendedblockstorage = chunk.func_76587_i()[y2 >> 4]) == Chunk.field_186036_a) continue;
                    extendedblockstorage.func_76657_c(x, y2 & 0xF, z, light);
                } while (--y2 > 0 && light > 0);
            }
        }
        chunk.func_76630_e();
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    private static class SegmentStorage {
        private final ExtendedBlockStorage blockStorage;
        private final byte[] opacity = new byte[4096];

        public SegmentStorage(int y, boolean storeSkylight) {
            this.blockStorage = new ExtendedBlockStorage(y, storeSkylight);
        }
    }

    private static class BlockStateCacher {
        private final int[] cache;
        private BlockStateContainer container;

        public BlockStateCacher(IChunkMaskTransformer transformer) {
            this.cache = new int[transformer.getBlockCount()];
        }

        public void update(BlockStateContainer container) {
            this.container = container;
            this.reset();
        }

        public int getValue(IChunkMaskTransformer transformer, int index) {
            if (this.container == null) {
                throw new IllegalStateException("Not yet initialized");
            }
            int state = this.cache[index];
            if (state < 0) {
                int bits = this.container.field_186024_e;
                state = this.container.field_186022_c.func_186041_a(transformer.getBlockState(index));
                if (bits != this.container.field_186024_e) {
                    this.reset();
                }
                this.cache[index] = state;
            }
            return state;
        }

        private void reset() {
            Arrays.fill(this.cache, -1);
        }
    }
}

