/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.preparation.capability;

import com.gildedgames.aether.api.world.preparation.IPrepManager;
import com.gildedgames.aether.api.world.preparation.IPrepRegistryEntry;
import com.gildedgames.aether.api.world.preparation.IPrepSectorAccess;
import com.gildedgames.aether.api.world.preparation.IPrepSectorData;
import com.gildedgames.aether.common.world.preparation.access.PrepSectorAccessClient;
import com.gildedgames.aether.common.world.preparation.access.PrepSectorAccessServer;
import com.gildedgames.orbis.lib.OrbisLib;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class PrepManager
implements IPrepManager {
    private final World world;
    private final IPrepRegistryEntry registry;
    private IPrepSectorAccess access;

    public PrepManager() {
        this.world = null;
        this.registry = null;
    }

    public PrepManager(World world, IPrepRegistryEntry registry) {
        this.world = world;
        this.registry = registry;
        this.access = world.field_72995_K ? new PrepSectorAccessClient(this.world, this.registry) : new PrepSectorAccessServer(this.world, this.registry, this, OrbisLib.services().getWorldDataManager(world));
    }

    @Override
    public IPrepRegistryEntry getRegistryEntry() {
        return this.registry;
    }

    @Override
    public IPrepSectorAccess getAccess() {
        return this.access;
    }

    @Override
    public IPrepSectorData createSector(int sectorX, int sectorZ) {
        long seed = this.world.func_72905_C() ^ (long)sectorX * 341873128712L + (long)sectorZ * 132897987541L;
        return this.registry.createData(this.world, seed, sectorX, sectorZ);
    }

    @Override
    public void decorateSectorData(IPrepSectorData data) {
        this.registry.postSectorDataCreate(this.world, data);
    }

    public static class Storage
    implements Capability.IStorage<IPrepManager> {
        @Nullable
        public NBTBase writeNBT(Capability<IPrepManager> capability, IPrepManager instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<IPrepManager> capability, IPrepManager instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

