/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.preparation.access;

import com.gildedgames.aether.api.world.preparation.IPrepManager;
import com.gildedgames.aether.api.world.preparation.IPrepRegistryEntry;
import com.gildedgames.aether.api.world.preparation.IPrepSector;
import com.gildedgames.aether.api.world.preparation.IPrepSectorAccess;
import com.gildedgames.aether.api.world.preparation.IPrepSectorData;
import com.gildedgames.aether.common.world.preparation.PrepSector;
import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.util.ChunkMap;
import com.gildedgames.orbis.lib.world.data.IWorldData;
import com.gildedgames.orbis.lib.world.data.IWorldDataManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PrepSectorAccessServer
implements IPrepSectorAccess,
IWorldData {
    private static final int THREADS = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Sector Access %d").build();
    private final World world;
    private final ListeningExecutorService foregroundService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(threadFactory));
    private final ListeningExecutorService backgroundService = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(0, THREADS, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), threadFactory));
    private final IPrepRegistryEntry registry;
    private final IPrepManager prepManager;
    private final ChunkMap<IPrepSector> loaded = new ChunkMap();
    private final ChunkMap<IPrepSector> generating = new ChunkMap();
    private final ChunkMap<ListenableFuture<IPrepSector>> loading = new ChunkMap();
    private final IWorldDataManager dataManager;
    private final ArrayList<IPrepSector> dirty = new ArrayList();

    public PrepSectorAccessServer(World world, IPrepRegistryEntry registry, IPrepManager prepManager, IWorldDataManager dataManager) {
        this.world = world;
        this.prepManager = prepManager;
        this.registry = registry;
        this.dataManager = dataManager;
        this.dataManager.register((IWorldData)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<IPrepSector> getLoadedSector(int sectorX, int sectorZ) {
        ChunkMap<IPrepSector> chunkMap = this.generating;
        synchronized (chunkMap) {
            IPrepSector job = (IPrepSector)this.generating.get(sectorX, sectorZ);
            if (job != null) {
                return Optional.of(job);
            }
        }
        return Optional.ofNullable(this.loaded.get(sectorX, sectorZ));
    }

    @Override
    public Optional<IPrepSector> getLoadedSectorForChunk(int chunkX, int chunkZ) {
        int sectorX = Math.floorDiv(chunkX, this.registry.getSectorChunkArea());
        int sectorZ = Math.floorDiv(chunkZ, this.registry.getSectorChunkArea());
        return this.getLoadedSector(sectorX, sectorZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<IPrepSector> provideSector(int sectorX, int sectorZ, boolean background) {
        ChunkMap<ListenableFuture<IPrepSector>> chunkMap = this.loading;
        synchronized (chunkMap) {
            if (this.loading.containsKey(sectorX, sectorZ)) {
                return (ListenableFuture)this.loading.get(sectorX, sectorZ);
            }
        }
        Optional<IPrepSector> sector = this.getLoadedSector(sectorX, sectorZ);
        if (sector.isPresent()) {
            return Futures.immediateFuture((Object)sector.get());
        }
        ChunkMap<ListenableFuture<IPrepSector>> chunkMap2 = this.loading;
        synchronized (chunkMap2) {
            ListeningExecutorService service = background ? this.backgroundService : this.foregroundService;
            ListenableFuture future = service.submit(() -> this.loadSector(sectorX, sectorZ));
            this.loading.put(sectorX, sectorZ, (Object)future);
            return future;
        }
    }

    @Override
    public ListenableFuture<IPrepSector> provideSectorForChunk(int chunkX, int chunkZ, boolean background) {
        int sectorX = Math.floorDiv(chunkX, this.registry.getSectorChunkArea());
        int sectorZ = Math.floorDiv(chunkZ, this.registry.getSectorChunkArea());
        return this.provideSector(sectorX, sectorZ, background);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPrepSector loadSector(int sectorX, int sectorZ) throws IOException {
        PrepSector sector;
        IPrepSectorData data = this.readSectorDataFromDisk(sectorX, sectorZ);
        if (data != null) {
            sector = new PrepSector(data);
        } else {
            OrbisLib.LOGGER.info("Generating Sector (" + sectorX + ", " + sectorZ + ")");
            long startTime = System.currentTimeMillis();
            data = this.prepManager.createSector(sectorX, sectorZ);
            sector = new PrepSector(data);
            ChunkMap<IPrepSector> chunkMap = this.generating;
            synchronized (chunkMap) {
                this.generating.put(sectorX, sectorZ, (Object)sector);
            }
            this.prepManager.decorateSectorData(data);
            chunkMap = this.generating;
            synchronized (chunkMap) {
                this.generating.remove(sectorX, sectorZ);
            }
            sector.getData().markDirty();
            long duration = System.currentTimeMillis() - startTime;
            OrbisLib.LOGGER.info("Finished generating Sector (" + sectorX + ", " + sectorZ + ") in " + duration + "ms");
        }
        return sector;
    }

    @Override
    public void onChunkLoaded(int chunkX, int chunkZ) {
        try {
            IPrepSector sector = (IPrepSector)this.provideSectorForChunk(chunkX, chunkZ, false).get();
            if (sector == null) {
                return;
            }
            sector.addWatchingChunk(chunkX, chunkZ);
            this.retainSector(sector);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onChunkUnloaded(int chunkX, int chunkZ) {
        this.getLoadedSectorForChunk(chunkX, chunkZ).ifPresent(sector -> sector.removeWatchingChunk(chunkX, chunkZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retainSector(IPrepSector sector) {
        int sectorX = sector.getData().getSectorX();
        int sectorZ = sector.getData().getSectorY();
        ChunkMap<IPrepSector> chunkMap = this.loaded;
        synchronized (chunkMap) {
            if (!this.loaded.containsKey(sectorX, sectorZ)) {
                this.loaded.put(sectorX, sectorZ, (Object)sector);
            }
        }
    }

    @Override
    public Collection<IPrepSector> getLoadedSectors() {
        return this.loaded.getValues();
    }

    public ResourceLocation getName() {
        return this.registry.getUniqueId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<IPrepSector> dirty;
        ArrayList<IPrepSector> arrayList = this.dirty;
        synchronized (arrayList) {
            dirty = new ArrayList<IPrepSector>(this.dirty);
            this.dirty.clear();
        }
        for (IPrepSector sector : dirty) {
            try {
                this.writeSectorDataToDisk(sector.getData());
            }
            catch (IOException e) {
                OrbisLib.LOGGER.warn("Failed to flush sector", (Throwable)e);
            }
            sector.getData().markClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        this.loading.getInnerMap().long2ObjectEntrySet().removeIf(entry -> ((ListenableFuture)entry.getValue()).isDone() || ((ListenableFuture)entry.getValue()).isCancelled());
        ChunkMap<IPrepSector> chunkMap = this.loaded;
        synchronized (chunkMap) {
            ArrayList<IPrepSector> removal = new ArrayList<IPrepSector>();
            for (IPrepSector sector : this.loaded.getValues()) {
                sector.tick();
                if (sector.getData().isDirty()) {
                    ArrayList<IPrepSector> arrayList = this.dirty;
                    synchronized (arrayList) {
                        this.dirty.add(sector);
                        continue;
                    }
                }
                if (sector.getDormantTicks() <= 6000) continue;
                removal.add(sector);
            }
            for (IPrepSector sector : removal) {
                this.loaded.remove(sector.getData().getSectorX(), sector.getData().getSectorY());
            }
        }
    }

    private String getSectorFileName(int sectorX, int sectorZ) {
        return "sector_" + sectorX + "_" + sectorZ + ".nbt.gz";
    }

    private IPrepSectorData readSectorDataFromDisk(int sectorX, int sectorY) throws IOException {
        byte[] bytes = this.dataManager.readBytes((IWorldData)this, this.getSectorFileName(sectorX, sectorY));
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            IPrepSectorData sector = this.readSectorDataFromStream(stream);
            if (sector.getSectorX() != sectorX || sector.getSectorY() != sectorY) {
                throw new IOException(String.format("Sector has wrong coordinates on disk! (expected [%s, %s], found [%s, %s])", sectorX, sectorY, sector.getSectorX(), sector.getSectorY()));
            }
            IPrepSectorData iPrepSectorData = sector;
            return iPrepSectorData;
        }
    }

    private IPrepSectorData readSectorDataFromStream(InputStream stream) throws IOException {
        NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)stream);
        return this.registry.createDataAndRead(this.world, tag);
    }

    private void writeSectorDataToDisk(IPrepSectorData sectorData) throws IOException {
        byte[] bytes;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.writeSectorDataToStream(sectorData, out);
            bytes = out.toByteArray();
        }
        this.dataManager.writeBytes((IWorldData)this, this.getSectorFileName(sectorData.getSectorX(), sectorData.getSectorY()), bytes);
    }

    private void writeSectorDataToStream(IPrepSectorData sector, OutputStream out) throws IOException {
        NBTTagCompound tag = new NBTTagCompound();
        sector.write(tag);
        CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)out);
    }
}

