/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.preparation;

import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.world.preparation.IPrepManager;
import com.gildedgames.aether.api.world.preparation.IPrepSector;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.world.World;

public class PrepHelper {
    @Nullable
    public static IPrepManager getManager(World world) {
        IPrepManager access = null;
        if (world.hasCapability(CapabilitiesAether.PREP_MANAGER, null)) {
            access = (IPrepManager)world.getCapability(CapabilitiesAether.PREP_MANAGER, null);
        }
        return access;
    }

    public static IPrepSector getSector(World world, int chunkX, int chunkY) {
        IPrepManager manager = PrepHelper.getManager(world);
        if (manager == null) {
            return null;
        }
        try {
            return (IPrepSector)manager.getAccess().provideSectorForChunk(chunkX, chunkY, false).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSectorLoaded(World world, int chunkX, int chunkY) {
        IPrepManager manager = PrepHelper.getManager(world);
        return PrepHelper.isSectorLoaded(manager, chunkX, chunkY);
    }

    public static boolean isSectorLoaded(IPrepManager manager, int chunkX, int chunkY) {
        Optional<IPrepSector> sector = manager.getAccess().getLoadedSectorForChunk(chunkX, chunkY);
        return sector.isPresent();
    }
}

