/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.preparation;

import com.gildedgames.aether.api.world.preparation.IPrepManager;
import com.gildedgames.aether.common.world.preparation.PrepHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PrepEventListener {
    @SubscribeEvent
    public static void onChunkLoaded(ChunkEvent.Load event) {
        World world = event.getWorld();
        IPrepManager manager = PrepHelper.getManager(world);
        if (manager != null) {
            manager.getAccess().onChunkLoaded(event.getChunk().field_76635_g, event.getChunk().field_76647_h);
        }
    }

    @SubscribeEvent
    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        World world = event.getWorld();
        IPrepManager manager = PrepHelper.getManager(world);
        if (manager != null) {
            manager.getAccess().onChunkUnloaded(event.getChunk().field_76635_g, event.getChunk().field_76647_h);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        IPrepManager manager = PrepHelper.getManager(world);
        if (manager != null) {
            manager.getAccess().update();
        }
    }
}

