/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.preparation;

import com.gildedgames.aether.api.world.preparation.IChunkInfo;
import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.api.world.preparation.IPrepChunkManager;
import com.gildedgames.aether.api.world.preparation.IPrepRegistryEntry;
import com.gildedgames.aether.api.world.preparation.IPrepSectorData;
import com.gildedgames.aether.common.world.preparation.mask.ChunkMask;
import com.gildedgames.orbis.lib.util.ChunkMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class PrepChunkManager<T extends IChunkInfo>
implements IPrepChunkManager<T> {
    private World world;
    private IPrepRegistryEntry<T> registryEntry;
    private final ChunkMap<ChunkMask> chunkCache = new ChunkMap();

    public PrepChunkManager() {
    }

    public PrepChunkManager(World world, IPrepRegistryEntry<T> registryEntry) {
        this.world = world;
        this.registryEntry = registryEntry;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public ChunkMask getChunk(IPrepSectorData sectorData, int chunkX, int chunkZ) {
        ChunkMask mask = (ChunkMask)this.chunkCache.get(chunkX, chunkZ);
        if (mask != null) {
            return mask;
        }
        mask = new ChunkMask(chunkX, chunkZ);
        IChunkInfo info = (IChunkInfo)this.registryEntry.generateChunkColumnInfo(this.world, sectorData, chunkX, chunkZ);
        this.registryEntry.threadSafeGenerateMask(info, this.world, sectorData, mask, chunkX, chunkZ);
        this.chunkCache.put(chunkX, chunkZ, (Object)mask);
        return mask;
    }

    @Override
    public IChunkMaskTransformer createMaskTransformer() {
        return this.registryEntry.createMaskTransformer();
    }

    public static class Storage
    implements Capability.IStorage<IPrepChunkManager> {
        @Nullable
        public NBTBase writeNBT(Capability<IPrepChunkManager> capability, IPrepChunkManager instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<IPrepChunkManager> capability, IPrepChunkManager instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

