/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.noise.impl;

import com.gildedgames.aether.api.util.OpenSimplexNoise;
import com.gildedgames.aether.api.world.islands.IIslandBounds;
import com.gildedgames.aether.api.world.noise.INoiseGenerator2D;

public class NoiseGeneratorIslandTerrain
implements INoiseGenerator2D {
    private static final double NOISE_SCALE = 300.0;
    private final OpenSimplexNoise noise;
    private final double offsetX;
    private final double offsetZ;

    public NoiseGeneratorIslandTerrain(OpenSimplexNoise noise, IIslandBounds bounds) {
        this(noise, bounds.getMinX(), bounds.getMinZ());
    }

    public NoiseGeneratorIslandTerrain(OpenSimplexNoise noise, IIslandBounds bounds, int offset) {
        this(noise, bounds.getMinX() + offset, bounds.getMinZ() + offset);
    }

    public NoiseGeneratorIslandTerrain(OpenSimplexNoise noise, int offsetX, int offsetZ) {
        this.noise = noise;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
    }

    @Override
    public double generate(double worldX, double worldZ) {
        double noiseX = (worldX + this.offsetX) / 300.0;
        double noiseZ = (worldZ + this.offsetZ) / 300.0;
        double noise1 = this.noise.eval(noiseX, noiseZ);
        double noise2 = 0.5 * this.noise.eval(noiseX * 8.0, noiseZ * 8.0);
        double noise3 = 0.25 * this.noise.eval(noiseX * 16.0, noiseZ * 16.0);
        double noise4 = 0.1 * this.noise.eval(noiseX * 32.0, noiseZ * 32.0);
        return (noise1 + noise2 + noise3 + noise4) / 4.0;
    }
}

