/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.noise;

import com.gildedgames.aether.api.world.noise.IChunkNoiseBuffer3D;

public class InterpolatedChunkNoiseBuffer3D
implements IChunkNoiseBuffer3D {
    private final float[][] samples;
    private final float noiseScaleFactorXZ;
    private final int sampleCountXZ;

    public InterpolatedChunkNoiseBuffer3D(float[][] samples, double noiseScaleFactorXZ, int sampleCountXZ) {
        this.samples = samples;
        this.noiseScaleFactorXZ = 1.0f / (float)noiseScaleFactorXZ;
        this.sampleCountXZ = sampleCountXZ;
    }

    @Override
    public float get(int x, int y, int z) {
        float x0 = (float)x * this.noiseScaleFactorXZ;
        float z0 = (float)z * this.noiseScaleFactorXZ;
        int integerX = (int)x0;
        int integerZ = (int)z0;
        float[] row = this.samples[y];
        float a = row[integerX * this.sampleCountXZ + integerZ];
        float b = row[integerX * this.sampleCountXZ + integerZ + 1];
        float c = row[(integerX + 1) * this.sampleCountXZ + integerZ];
        float d = row[(integerX + 1) * this.sampleCountXZ + integerZ + 1];
        float r1 = a + (b - a) * (z0 - (float)integerZ);
        float r2 = c + (d - c) * (z0 - (float)integerZ);
        return r1 + (r2 - r1) * (x0 - (float)integerX);
    }
}

