/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.noise;

import com.gildedgames.aether.api.world.noise.IChunkNoiseBuffer2D;

public class InterpolatedChunkNoiseBuffer2D
implements IChunkNoiseBuffer2D {
    private final float[] samples;
    private final int sampleCount;
    private final float noiseScaleFactor;

    public InterpolatedChunkNoiseBuffer2D(float[] samples, int sampleCount, double noiseScaleFactor) {
        this.samples = samples;
        this.sampleCount = sampleCount;
        this.noiseScaleFactor = 1.0f / (float)noiseScaleFactor;
    }

    @Override
    public float get(int x, int z) {
        float x0 = (float)x * this.noiseScaleFactor;
        float z0 = (float)z * this.noiseScaleFactor;
        int integerX = (int)x0;
        int integerZ = (int)z0;
        float fractionX = x0 - (float)integerX;
        float fractionZ = z0 - (float)integerZ;
        float a = this.samples[integerX * this.sampleCount + integerZ];
        float b = this.samples[integerX * this.sampleCount + integerZ + 1];
        float c = this.samples[(integerX + 1) * this.sampleCount + integerZ];
        float d = this.samples[(integerX + 1) * this.sampleCount + integerZ + 1];
        float r1 = a + (b - a) * fractionZ;
        float r2 = c + (d - c) * fractionZ;
        return r1 + (r2 - r1) * fractionX;
    }
}

