/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.noise;

public abstract class ChunkDataGenerator3D<T> {
    protected final double noiseScaleFactorXZ;
    protected final double noiseScaleFactorY;
    protected final int noiseSampleCountXZ;
    protected final int noiseSampleCountY;

    public ChunkDataGenerator3D(int noiseResolutionXZ, int noiseResolutionY) {
        if (noiseResolutionXZ > 16) {
            throw new IllegalArgumentException("Resolution must not be greater than 16");
        }
        this.noiseScaleFactorXZ = 16.0 / (double)noiseResolutionXZ;
        this.noiseSampleCountXZ = noiseResolutionXZ + 1;
        this.noiseScaleFactorY = 256.0 / (double)noiseResolutionY;
        this.noiseSampleCountY = noiseResolutionY + 1;
    }

    public final T generate(int chunkX, int chunkZ) {
        T data = this.prepare(chunkX, chunkZ);
        int posX = chunkX * 16;
        int posZ = chunkZ * 16;
        for (int x = 0; x < this.noiseSampleCountXZ; ++x) {
            double worldX = (double)posX + (double)x * this.noiseScaleFactorXZ;
            for (int z = 0; z < this.noiseSampleCountXZ; ++z) {
                double worldZ = (double)posZ + (double)z * this.noiseScaleFactorXZ;
                for (int y = 0; y < this.noiseSampleCountY; ++y) {
                    double worldY = (double)y * this.noiseScaleFactorY;
                    this.generate(data, x, y, z, worldX, worldY, worldZ);
                }
            }
        }
        return data;
    }

    protected abstract T prepare(int var1, int var2);

    protected abstract void generate(T var1, int var2, int var3, int var4, double var5, double var7, double var9);
}

