/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.noise;

public abstract class ChunkDataGenerator2D<T> {
    protected final double noiseScaleFactor;
    protected final int noiseSampleCount;

    public ChunkDataGenerator2D(int noiseResolution) {
        if (noiseResolution > 16) {
            throw new IllegalArgumentException("Resolution must not be greater than 16");
        }
        this.noiseScaleFactor = 16.0 / (double)noiseResolution;
        this.noiseSampleCount = noiseResolution + 1;
    }

    public final T generate(int chunkX, int chunkZ) {
        T data = this.prepare(chunkX, chunkZ);
        int posX = chunkX * 16;
        int posZ = chunkZ * 16;
        for (int x = 0; x < this.noiseSampleCount; ++x) {
            double worldX = (double)posX + (double)x * this.noiseScaleFactor;
            for (int z = 0; z < this.noiseSampleCount; ++z) {
                double worldZ = (double)posZ + (double)z * this.noiseScaleFactor;
                this.generate(data, x, z, worldX, worldZ);
            }
        }
        return data;
    }

    protected abstract T prepare(int var1, int var2);

    protected abstract void generate(T var1, int var2, int var3, double var4, double var6);
}

