/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.island.generators;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.util.NoiseUtil;
import com.gildedgames.aether.api.util.OpenSimplexNoise;
import com.gildedgames.aether.api.world.IChunkInfoAether;
import com.gildedgames.aether.api.world.islands.IIslandBounds;
import com.gildedgames.aether.api.world.islands.IIslandChunkInfo;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.islands.IIslandGenerator;
import com.gildedgames.aether.api.world.noise.IChunkNoiseBuffer2D;
import com.gildedgames.aether.api.world.noise.INoiseGenerator2D;
import com.gildedgames.aether.api.world.preparation.IChunkMask;
import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.blocks.natural.BlockAetherGrass;
import com.gildedgames.aether.common.world.biomes.irradiated_forests.CrackLineSegment;
import com.gildedgames.aether.common.world.biomes.irradiated_forests.IrradiatedForestsData;
import com.gildedgames.aether.common.world.island.AbstractIslandChunkInfo;
import com.gildedgames.aether.common.world.island.IslandBlockType;
import com.gildedgames.aether.common.world.island.IslandChunkMaskTransformer;
import com.gildedgames.aether.common.world.noise.ChunkDataGenerator2D;
import com.gildedgames.aether.common.world.noise.NoiseSampleData2D;
import com.gildedgames.aether.common.world.noise.impl.NoiseGeneratorIslandTerrain;
import com.gildedgames.orbis.lib.util.ObjectFilter;
import java.util.Collection;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.MathHelper;

public class IslandGeneratorIrradiatedForests
implements IIslandGenerator {
    private static final int BOTTOM_HEIGHT = 100;
    private static final double CUTOFF_POINT = 0.325;
    private static final double TOP_HEIGHT = 80.0;
    private static final double ISLAND_EDGE_BLEND_RANGE = 0.1;
    private static final double ISLAND_BOTTOM_BLEND_RANGE = 0.25;
    private static final double ISLAND_EDGE = 0.75;

    @Override
    public void generateChunkSegment(IChunkInfoAether info, IChunkMask mask, IIslandData island, int chunkX, int chunkZ) {
        IrradiatedForestsChunkInfo column = info.getIslandData(0, IrradiatedForestsChunkInfo.class);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int bottom;
                int top;
                double cutoffPoint;
                double heightSample = column.heightSample_xz.get(x, z);
                if (heightSample <= (cutoffPoint = 0.325)) continue;
                float topHeight = column.topHeight.get(x, z);
                float bottomHeight = column.bottomHeight.get(x, z);
                double closestCrackDist = column.distToCrack.get(x, z);
                if (closestCrackDist < 10.0) {
                    double f = Math.max(0.0, (closestCrackDist - 5.0) / 5.0);
                    topHeight = (float)((double)topHeight * f);
                    bottomHeight = (float)((double)bottomHeight * f);
                }
                if ((top = (int)topHeight) + (bottom = (int)bottomHeight) == 0) continue;
                int minY = Math.max(100 - bottom, 0);
                int maxY = Math.min(100 + top, 255);
                boolean mossy = (double)column.distToCrack.get(x, z) < 12.0;
                for (int y = minY; y <= maxY; ++y) {
                    mask.setBlock(x, y, z, mossy ? IslandBlockType.STONE_MOSSY_BLOCK.ordinal() : IslandBlockType.STONE_BLOCK.ordinal());
                }
            }
        }
    }

    @Override
    public IChunkMaskTransformer createMaskTransformer(IIslandData island, int chunkX, int chunkZ) {
        IslandChunkMaskTransformer transformer = new IslandChunkMaskTransformer();
        transformer.setMaskValue(IslandBlockType.TOPSOIL_BLOCK, BlocksAether.aether_grass.func_176223_P().func_177226_a((IProperty)BlockAetherGrass.PROPERTY_VARIANT, (Comparable)BlockAetherGrass.IRRADIATED));
        return transformer;
    }

    @Override
    public IIslandChunkInfo generateColumnInfo(OpenSimplexNoise noise, IIslandData island, int chunkX, int chunkZ) {
        ChunkDataGeneratorIrradiatedForests generator = new ChunkDataGeneratorIrradiatedForests(noise, island);
        return new IrradiatedForestsChunkInfo(noise, (NoiseDataIrradiatedForests)generator.generate(chunkX, chunkZ));
    }

    private class NoiseDataIrradiatedForests {
        final NoiseSampleData2D topHeight;
        final NoiseSampleData2D bottomHeight;
        final NoiseSampleData2D heightSample_xz;
        final NoiseSampleData2D topSample_xz;
        final NoiseSampleData2D distToCrack_xz;
        final Collection<CrackLineSegment> cracks;
        final int chunkX;
        final int chunkZ;

        public NoiseDataIrradiatedForests(IIslandData island, double noiseScaleFactor, int noiseResolution, int chunkX, int chunkZ) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.topHeight = new NoiseSampleData2D(noiseScaleFactor, noiseResolution);
            this.bottomHeight = new NoiseSampleData2D(noiseScaleFactor, noiseResolution);
            this.distToCrack_xz = new NoiseSampleData2D(noiseScaleFactor, noiseResolution);
            this.heightSample_xz = new NoiseSampleData2D(noiseScaleFactor, noiseResolution);
            this.topSample_xz = new NoiseSampleData2D(noiseScaleFactor, noiseResolution);
            IrradiatedForestsData data = (IrradiatedForestsData)ObjectFilter.getFirstFrom(island.getComponents(), IrradiatedForestsData.class);
            if (data == null) {
                throw new RuntimeException("IrradiatedForestsData could not be found");
            }
            long start = System.nanoTime();
            if (data.checkInit()) {
                AetherCore.LOGGER.info("Data generation took {}ns", (Object)(System.nanoTime() - start));
            }
            this.cracks = data.getCracksInRegion(chunkX, chunkZ, 1);
        }
    }

    private class ChunkDataGeneratorIrradiatedForests
    extends ChunkDataGenerator2D<NoiseDataIrradiatedForests> {
        private static final int NOISE_RESOLUTION = 3;
        private final INoiseGenerator2D terrain;
        private final INoiseGenerator2D terrace;
        private final IIslandData island;
        private final double centerX;
        private final double centerZ;
        private final double radiusX;
        private final double radiusZ;

        public ChunkDataGeneratorIrradiatedForests(OpenSimplexNoise noise, IIslandData island) {
            super(3);
            this.island = island;
            IIslandBounds bounds = island.getBounds();
            this.centerX = bounds.getCenterX();
            this.centerZ = bounds.getCenterZ();
            this.radiusX = (double)bounds.getWidth() / 2.0;
            this.radiusZ = (double)bounds.getLength() / 2.0;
            this.terrain = new NoiseGeneratorIslandTerrain(noise, island.getBounds());
            this.terrace = new NoiseGeneratorIslandTerrain(noise, island.getBounds(), 1000);
        }

        @Override
        protected NoiseDataIrradiatedForests prepare(int chunkX, int chunkZ) {
            return new NoiseDataIrradiatedForests(this.island, this.noiseScaleFactor, this.noiseSampleCount, chunkX, chunkZ);
        }

        @Override
        protected void generate(NoiseDataIrradiatedForests data, int x, int z, double worldX, double worldZ) {
            double blend;
            double thresh;
            double sample = this.terrain.generate(worldX, worldZ) * 0.7;
            double distX = Math.abs((this.centerX - worldX) * (1.0 / this.radiusX));
            double distZ = Math.abs((this.centerZ - worldZ) * (1.0 / this.radiusZ));
            double dist = Math.sqrt(distX * distX + distZ * distZ) / 1.0;
            double heightSample = sample + 1.0 - dist;
            double closestCrackDist = Double.POSITIVE_INFINITY;
            for (CrackLineSegment edge : data.cracks) {
                double d = edge.distanceToPoint(worldX, worldZ);
                if (!(d < closestCrackDist)) continue;
                closestCrackDist = d;
            }
            double normal = NoiseUtil.normalise(sample);
            double cutoffPointDist = Math.abs(0.325 - heightSample);
            double diff = Math.max(0.0, 0.325 - cutoffPointDist) * 8.0;
            double terraceSample = this.terrace.generate(worldX, worldZ) + 1.0;
            double topSample = NoiseUtil.lerp(heightSample, terraceSample - diff > 0.7 ? terraceSample - diff : heightSample, 0.7);
            double bottomSample = Math.min(1.0, normal + 0.25);
            double islandBottom = bottomSample * 0.25 + 0.75;
            if (heightSample < 0.42500000000000004) {
                thresh = heightSample - 0.325;
                blend = thresh * 10.0;
                bottomSample = NoiseUtil.lerp(0.0, 0.75, blend);
            } else if (heightSample < 0.6749999999999999) {
                thresh = heightSample - 0.325 - 0.1;
                blend = thresh * 4.0;
                bottomSample = NoiseUtil.lerp(0.75, islandBottom, blend);
            }
            double topHeight = (topSample - 0.325) * 80.0;
            double bottomHeight = 100.0 * bottomSample;
            topHeight = MathHelper.func_151237_a((double)topHeight, (double)0.0, (double)254.0);
            bottomHeight = MathHelper.func_151237_a((double)bottomHeight, (double)0.0, (double)254.0);
            data.topHeight.set(x, z, (float)topHeight);
            data.bottomHeight.set(x, z, (float)bottomHeight);
            data.distToCrack_xz.set(x, z, (float)closestCrackDist);
            data.heightSample_xz.set(x, z, (float)heightSample);
            data.topSample_xz.set(x, z, (float)topSample);
        }
    }

    private class IrradiatedForestsChunkInfo
    extends AbstractIslandChunkInfo {
        final IChunkNoiseBuffer2D topHeight;
        final IChunkNoiseBuffer2D bottomHeight;
        final IChunkNoiseBuffer2D heightSample_xz;
        final IChunkNoiseBuffer2D topSample_xz;
        final IChunkNoiseBuffer2D distToCrack;

        IrradiatedForestsChunkInfo(OpenSimplexNoise noise, NoiseDataIrradiatedForests data) {
            super(noise, data.chunkX, data.chunkZ);
            this.topHeight = data.topHeight.createInterpolatedNoiseBuffer();
            this.bottomHeight = data.bottomHeight.createInterpolatedNoiseBuffer();
            this.distToCrack = data.distToCrack_xz.createInterpolatedNoiseBuffer();
            this.heightSample_xz = data.heightSample_xz.createInterpolatedNoiseBuffer();
            this.topSample_xz = data.topSample_xz.createInterpolatedNoiseBuffer();
        }
    }
}

