/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.island.generators;

import com.gildedgames.aether.api.util.NoiseUtil;
import com.gildedgames.aether.api.util.OpenSimplexNoise;
import com.gildedgames.aether.api.world.IChunkInfoAether;
import com.gildedgames.aether.api.world.islands.IIslandBounds;
import com.gildedgames.aether.api.world.islands.IIslandChunkInfo;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.islands.IIslandGenerator;
import com.gildedgames.aether.api.world.noise.IChunkNoiseBuffer2D;
import com.gildedgames.aether.api.world.noise.INoiseGenerator2D;
import com.gildedgames.aether.api.world.preparation.IChunkMask;
import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.island.AbstractIslandChunkInfo;
import com.gildedgames.aether.common.world.island.IslandBlockType;
import com.gildedgames.aether.common.world.island.IslandChunkMaskTransformer;
import com.gildedgames.aether.common.world.island.IslandVariables;
import com.gildedgames.aether.common.world.noise.ChunkDataGenerator2D;
import com.gildedgames.aether.common.world.noise.NoiseSampleData2D;
import com.gildedgames.aether.common.world.noise.impl.NoiseGeneratorIslandTerrain;
import net.minecraft.util.math.MathHelper;

public class IslandGeneratorHighlands
implements IIslandGenerator {
    private static final double ISLAND_EDGE_BLEND_RANGE = 0.1;
    private static final double ISLAND_BOTTOM_BLEND_RANGE = 0.25;
    private static final double ISLAND_EDGE = 0.75;
    private static final double ISLAND_CUTOFF_POINT = 0.325;
    private static final int ISLAND_BOTTOM_HEIGHT = 100;
    private static final double SAMPLE_SCALE_FACTOR = 0.7;
    private final IslandVariables vars;

    public IslandGeneratorHighlands(IslandVariables variables) {
        this.vars = variables;
    }

    @Override
    public IIslandChunkInfo generateColumnInfo(OpenSimplexNoise noise, IIslandData island, int chunkX, int chunkZ) {
        ChunkDataGeneratorHighlands.NoiseDataHighlands data = (ChunkDataGeneratorHighlands.NoiseDataHighlands)new ChunkDataGeneratorHighlands(noise, island, this.vars).generate(chunkX, chunkZ);
        return new HighlandsChunkInfo(data, noise);
    }

    @Override
    public void generateChunkSegment(IChunkInfoAether columnInfo, IChunkMask mask, IIslandData island, int chunkX, int chunkZ) {
        HighlandsChunkInfo info = columnInfo.getIslandData(0, HighlandsChunkInfo.class);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int coastMaxY;
                int maxY = (int)info.maxY.get(x, z);
                int minY = (int)info.minY.get(x, z);
                boolean snowy = this.vars.hasSnowCaps() && (double)maxY > 100.0 + (double)this.vars.getMaxTerrainHeight() * 0.7;
                int m1a = Math.max(minY, 0);
                int m1b = Math.min(maxY, 255);
                int snowThreshold = maxY - 8;
                for (int y = m1a; y <= m1b; ++y) {
                    if (snowy && y > snowThreshold) {
                        mask.setBlock(x, y, z, IslandBlockType.SNOW_BLOCK.ordinal());
                        continue;
                    }
                    mask.setBlock(x, y, z, IslandBlockType.STONE_BLOCK.ordinal());
                }
                if (this.vars.getCoastHeight() <= 0 || maxY > (coastMaxY = 100 + this.vars.getCoastHeight())) continue;
                int m3a = Math.min(coastMaxY, 255);
                int m3b = Math.max(100, 0);
                for (int y = m3a; y >= m3b; --y) {
                    int state = mask.getBlock(x, y, z);
                    if (state != IslandBlockType.STONE_BLOCK.ordinal() && state != IslandBlockType.FERROSITE_BLOCK.ordinal()) continue;
                    mask.setBlock(x, y, z, IslandBlockType.COAST_BLOCK.ordinal());
                }
            }
        }
    }

    @Override
    public IChunkMaskTransformer createMaskTransformer(IIslandData island, int chunkX, int chunkZ) {
        BiomeAetherBase biome = (BiomeAetherBase)island.getBiome();
        IslandChunkMaskTransformer transformer = new IslandChunkMaskTransformer();
        transformer.setMaskValue(IslandBlockType.TOPSOIL_BLOCK, biome.field_76752_A);
        transformer.setMaskValue(IslandBlockType.SOIL_BLOCK, biome.field_76753_B);
        transformer.setMaskValue(IslandBlockType.COAST_BLOCK, biome.getCoastalBlock());
        return transformer;
    }

    private class HighlandsChunkInfo
    extends AbstractIslandChunkInfo {
        final IChunkNoiseBuffer2D minY;
        final IChunkNoiseBuffer2D maxY;

        HighlandsChunkInfo(ChunkDataGeneratorHighlands.NoiseDataHighlands data, OpenSimplexNoise noise) {
            super(noise, data.chunkX, data.chunkZ);
            this.minY = data.minY.createInterpolatedNoiseBuffer();
            this.maxY = data.maxY.createInterpolatedNoiseBuffer();
        }
    }

    private class ChunkDataGeneratorHighlands
    extends ChunkDataGenerator2D<NoiseDataHighlands> {
        private static final int NOISE_RESOLUTION = 3;
        private final IslandVariables vars;
        private final double centerX;
        private final double centerZ;
        private final double radiusX;
        private final double radiusZ;
        private final INoiseGenerator2D heightGen;
        private final INoiseGenerator2D terraceGen;

        public ChunkDataGeneratorHighlands(OpenSimplexNoise noise, IIslandData island, IslandVariables vars) {
            super(3);
            this.vars = vars;
            IIslandBounds bounds = island.getBounds();
            this.centerX = bounds.getCenterX();
            this.centerZ = bounds.getCenterZ();
            this.radiusX = (double)bounds.getWidth() / 2.0;
            this.radiusZ = (double)bounds.getLength() / 2.0;
            this.heightGen = new NoiseGeneratorIslandTerrain(noise, bounds, 0);
            this.terraceGen = new NoiseGeneratorIslandTerrain(noise, bounds, 1000);
        }

        @Override
        public NoiseDataHighlands prepare(int chunkX, int chunkZ) {
            return new NoiseDataHighlands(this.noiseScaleFactor, this.noiseSampleCount, chunkX, chunkZ);
        }

        @Override
        protected void generate(NoiseDataHighlands data, int x, int z, double worldX, double worldZ) {
            double blend;
            double thresh;
            double distX = Math.abs((this.centerX - worldX) * (1.0 / this.radiusX));
            double distZ = Math.abs((this.centerZ - worldZ) * (1.0 / this.radiusZ));
            double dist = Math.sqrt(distX * distX + distZ * distZ) / 1.0;
            double sample = this.heightGen.generate(worldX, worldZ) * 0.7;
            double heightSample = sample + 1.0 - dist;
            double topSample = this.vars.getHeightSampleFilter().transform(heightSample);
            if (this.vars.hasTerraces()) {
                double cutoffPointDist = Math.abs(0.325 - heightSample);
                double diff = Math.max(0.0, 0.325 - cutoffPointDist) * 8.0;
                double terraceSample = this.terraceGen.generate(worldX, worldZ) + 1.0;
                topSample = NoiseUtil.lerp(heightSample, terraceSample - diff > 0.7 ? terraceSample - diff : heightSample, 0.7);
            }
            topSample = Math.pow(topSample, 1.0 + this.vars.getCoastSpread() * 0.25);
            double normal = NoiseUtil.normalise(sample);
            double bottomSample = Math.max(1.0, normal + 0.25);
            if (heightSample < 0.42500000000000004) {
                thresh = heightSample - 0.325;
                blend = thresh * 10.0;
                bottomSample = NoiseUtil.lerp(0.0, 0.75, blend);
            } else if (heightSample < 0.6749999999999999) {
                thresh = heightSample - 0.325 - 0.1;
                blend = thresh * 4.0;
                double islandBottom = bottomSample * 0.25 + 0.75;
                bottomSample = NoiseUtil.lerp(0.75, islandBottom, blend);
            }
            double maxY = this.vars.getMaxYFilter().transform(100.0, topSample, 0.325);
            double minY = 100.0 - 100.0 * bottomSample;
            data.maxY.set(x, z, (float)MathHelper.func_151237_a((double)maxY, (double)100.0, (double)254.0));
            data.minY.set(x, z, (float)minY);
        }

        private class NoiseDataHighlands {
            final int chunkX;
            final int chunkZ;
            final NoiseSampleData2D minY;
            final NoiseSampleData2D maxY;

            NoiseDataHighlands(double noiseScaleFactor, int sampleCount, int chunkX, int chunkZ) {
                this.chunkX = chunkX;
                this.chunkZ = chunkZ;
                this.minY = new NoiseSampleData2D(noiseScaleFactor, sampleCount);
                this.maxY = new NoiseSampleData2D(noiseScaleFactor, sampleCount);
            }
        }
    }
}

