/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.island.generators;

import com.gildedgames.aether.api.util.NoiseUtil;
import com.gildedgames.aether.api.util.OpenSimplexNoise;
import com.gildedgames.aether.api.world.IChunkInfoAether;
import com.gildedgames.aether.api.world.islands.IIslandBounds;
import com.gildedgames.aether.api.world.islands.IIslandChunkInfo;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.islands.IIslandGenerator;
import com.gildedgames.aether.api.world.noise.IChunkNoiseBuffer2D;
import com.gildedgames.aether.api.world.noise.INoiseGenerator2D;
import com.gildedgames.aether.api.world.preparation.IChunkMask;
import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.common.world.island.AbstractIslandChunkInfo;
import com.gildedgames.aether.common.world.island.IslandBlockType;
import com.gildedgames.aether.common.world.island.IslandChunkMaskTransformer;
import com.gildedgames.aether.common.world.noise.ChunkDataGenerator2D;
import com.gildedgames.aether.common.world.noise.NoiseSampleData2D;
import com.gildedgames.aether.common.world.noise.impl.NoiseGeneratorIslandTerrain;

public class IslandGeneratorHighlandMegacoast
implements IIslandGenerator {
    private static final double CUTOFF_POINT = 0.325;
    private static final int BOTTOM_MAX_Y = 100;
    private static final int TOP_HEIGHT = 80;
    private static final int BOTTOM_HEIGHT = 100;
    private static final double TERRACE_WIDTH = 0.15;
    private static final double ISLAND_EDGE_BLEND_RANGE = 0.1;
    private static final double ISLAND_BOTTOM_BLEND_RANGE = 0.25;
    private static final double ISLAND_EDGE = 0.75;

    @Override
    public void generateChunkSegment(IChunkInfoAether info, IChunkMask mask, IIslandData island, int chunkX, int chunkZ) {
        HighlandMegacostChunkInfo column = info.getIslandData(0, HighlandMegacostChunkInfo.class);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int topHeight = (int)column.topHeight.get(x, z);
                int bottomHeight = (int)column.bottomHeight.get(x, z);
                int minY = Math.max(100 - bottomHeight, 0);
                int maxY = Math.min(100 + topHeight, 255);
                boolean coast = topHeight < 3;
                for (int y = minY; y <= maxY; ++y) {
                    if (coast && y > 98) {
                        mask.setBlock(x, y, z, IslandBlockType.COAST_BLOCK.ordinal());
                        continue;
                    }
                    mask.setBlock(x, y, z, IslandBlockType.STONE_BLOCK.ordinal());
                }
            }
        }
    }

    @Override
    public IChunkMaskTransformer createMaskTransformer(IIslandData island, int chunkX, int chunkZ) {
        return new IslandChunkMaskTransformer();
    }

    @Override
    public IIslandChunkInfo generateColumnInfo(OpenSimplexNoise noise, IIslandData island, int chunkX, int chunkZ) {
        ChunkDataGeneratorMegacoast.NoiseDataMegacoast data = (ChunkDataGeneratorMegacoast.NoiseDataMegacoast)new ChunkDataGeneratorMegacoast(noise, island).generate(chunkX, chunkZ);
        return new HighlandMegacostChunkInfo(data, noise);
    }

    private class HighlandMegacostChunkInfo
    extends AbstractIslandChunkInfo {
        final IChunkNoiseBuffer2D bottomHeight;
        final IChunkNoiseBuffer2D topHeight;

        HighlandMegacostChunkInfo(ChunkDataGeneratorMegacoast.NoiseDataMegacoast data, OpenSimplexNoise noise) {
            super(noise, data.chunkX, data.chunkZ);
            this.bottomHeight = data.bottomHeight.createInterpolatedNoiseBuffer();
            this.topHeight = data.topHeight.createInterpolatedNoiseBuffer();
        }
    }

    private class ChunkDataGeneratorMegacoast
    extends ChunkDataGenerator2D<NoiseDataMegacoast> {
        private static final int NOISE_RESOLUTION = 3;
        private final double centerX;
        private final double centerZ;
        private final double radiusX;
        private final double radiusZ;
        private final INoiseGenerator2D heightGen;

        public ChunkDataGeneratorMegacoast(OpenSimplexNoise noise, IIslandData island) {
            super(3);
            IIslandBounds bounds = island.getBounds();
            this.centerX = bounds.getCenterX();
            this.centerZ = bounds.getCenterZ();
            this.radiusX = (double)bounds.getWidth() / 2.0;
            this.radiusZ = (double)bounds.getLength() / 2.0;
            this.heightGen = new NoiseGeneratorIslandTerrain(noise, bounds, 0);
        }

        @Override
        public NoiseDataMegacoast prepare(int chunkX, int chunkZ) {
            return new NoiseDataMegacoast(this.noiseScaleFactor, this.noiseSampleCount, chunkX, chunkZ);
        }

        @Override
        protected void generate(NoiseDataMegacoast data, int x, int z, double worldX, double worldZ) {
            double thresh;
            double distX = Math.abs((this.centerX - worldX) * (1.0 / this.radiusX));
            double distZ = Math.abs((this.centerZ - worldZ) * (1.0 / this.radiusZ));
            double dist = Math.sqrt(distX * distX + distZ * distZ) / 1.0;
            double sample = this.heightGen.generate(worldX, worldZ) * 0.7;
            double heightSample = sample + 1.0 - dist;
            double k = Math.floor(heightSample / 0.15);
            double f = (heightSample - k * 0.15) / 0.05;
            double s = Math.min(2.0 * f, 1.0);
            double terrace = (k + s) * 0.15;
            double topSample = Math.pow(terrace, 2.5) + heightSample / 2.0;
            double normal = NoiseUtil.normalise(sample);
            double bottomSample = Math.min(1.0, normal + 0.25);
            double islandBottom = bottomSample * 0.25 + 0.75;
            if (heightSample < 0.42500000000000004) {
                thresh = heightSample - 0.325;
                double blend = thresh * 10.0;
                bottomSample = NoiseUtil.lerp(0.0, 0.75, blend);
            } else if (heightSample < 0.6749999999999999) {
                thresh = heightSample - 0.325 - 0.1;
                double blend = thresh * 4.0;
                bottomSample = NoiseUtil.lerp(0.75, islandBottom, blend);
            }
            double maxY = (topSample - 0.325) * 80.0;
            data.topHeight.set(x, z, (float)Math.max(0.0, maxY));
            data.bottomHeight.set(x, z, (float)(100.0 * bottomSample));
        }

        private class NoiseDataMegacoast {
            final int chunkX;
            final int chunkZ;
            final NoiseSampleData2D bottomHeight;
            final NoiseSampleData2D topHeight;

            NoiseDataMegacoast(double noiseScaleFactor, int sampleCount, int chunkX, int chunkZ) {
                this.chunkX = chunkX;
                this.chunkZ = chunkZ;
                this.bottomHeight = new NoiseSampleData2D(noiseScaleFactor, sampleCount);
                this.topHeight = new NoiseSampleData2D(noiseScaleFactor, sampleCount);
            }
        }
    }
}

