/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.island.generators;

import com.gildedgames.aether.api.util.NoiseUtil;
import com.gildedgames.aether.api.util.OpenSimplexNoise;
import com.gildedgames.aether.api.world.IChunkInfoAether;
import com.gildedgames.aether.api.world.islands.IIslandChunkInfo;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.islands.IIslandGenerator;
import com.gildedgames.aether.api.world.noise.IChunkNoiseBuffer3D;
import com.gildedgames.aether.api.world.preparation.IChunkMask;
import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.common.world.island.AbstractIslandChunkInfo;
import com.gildedgames.aether.common.world.island.IslandBlockType;
import com.gildedgames.aether.common.world.island.IslandChunkMaskTransformer;
import com.gildedgames.aether.common.world.noise.ChunkDataGenerator3D;
import com.gildedgames.aether.common.world.noise.NoiseSampleData3D;
import javax.annotation.Nonnull;

public class IslandGeneratorForgottenHighlands
implements IIslandGenerator {
    @Override
    public void generateChunkSegment(IChunkInfoAether info, IChunkMask mask, IIslandData island, int chunkX, int chunkZ) {
        ForgottenHighlandsInfo column = info.getIslandData(0, ForgottenHighlandsInfo.class);
        double k = 0.0625;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 15; ++y) {
                    float a = column.samples.get(x, y, z);
                    float b = column.samples.get(x, y + 1, z);
                    float t = 0.0f;
                    for (int y2 = 0; y2 < 16; ++y2) {
                        float result = a + (b - a) * t;
                        if (result > 0.2f) {
                            mask.setBlock(x, y * 16 + y2, z, IslandBlockType.STONE_BLOCK.ordinal());
                        }
                        t = (float)((double)t + k);
                    }
                }
            }
        }
    }

    @Override
    @Nonnull
    public IIslandChunkInfo generateColumnInfo(OpenSimplexNoise noise, IIslandData island, int chunkX, int chunkZ) {
        ForgottenHighlandsNoiseData noiseData = (ForgottenHighlandsNoiseData)new ChunkDataGeneratorForgottenHighlands(noise, island).generate(chunkX, chunkZ);
        return new ForgottenHighlandsInfo(noise, chunkX, chunkZ, noiseData);
    }

    @Override
    public IChunkMaskTransformer createMaskTransformer(IIslandData island, int chunkX, int chunkZ) {
        return new IslandChunkMaskTransformer();
    }

    private class ForgottenHighlandsInfo
    extends AbstractIslandChunkInfo {
        public final IChunkNoiseBuffer3D samples;

        protected ForgottenHighlandsInfo(OpenSimplexNoise noise, int chunkX, int chunkZ, ForgottenHighlandsNoiseData noiseData) {
            super(noise, chunkX, chunkZ);
            this.samples = noiseData.samples.createInterpolatedNoiseBuffer();
        }
    }

    private class ForgottenHighlandsNoiseData {
        private final NoiseSampleData3D samples;
        private final int chunkX;
        private final int chunkZ;

        private ForgottenHighlandsNoiseData(int chunkX, int chunkZ, double noiseScaleFactorXZ, double noiseScaleFactorY, int sampleCountXZ, int sampleCountY) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.samples = new NoiseSampleData3D(noiseScaleFactorXZ, noiseScaleFactorY, sampleCountXZ, sampleCountY);
        }
    }

    private class ChunkDataGeneratorForgottenHighlands
    extends ChunkDataGenerator3D<ForgottenHighlandsNoiseData> {
        private final double minX;
        private final double minZ;
        private final double centerX;
        private final double centerY;
        private final double centerZ;
        private final double radiusX;
        private final double radiusY;
        private final double radiusZ;
        private final double offset = 0.0;
        private final double scaleXZ = 300.0;
        private final double scaleY = 0.5;
        private final OpenSimplexNoise noise;
        private final boolean centerGradient = false;

        public ChunkDataGeneratorForgottenHighlands(OpenSimplexNoise noise, IIslandData island) {
            super(3, 15);
            this.offset = 0.0;
            this.scaleXZ = 300.0;
            this.scaleY = 0.5;
            this.centerGradient = false;
            this.noise = noise;
            this.minX = island.getBounds().getMinX();
            this.minZ = island.getBounds().getMinZ();
            this.centerX = island.getBounds().getCenterX();
            this.centerY = 100.0;
            this.centerZ = island.getBounds().getCenterZ();
            this.radiusX = (double)island.getBounds().getWidth() / 2.0;
            this.radiusY = 90.0;
            this.radiusZ = (double)island.getBounds().getLength() / 2.0;
        }

        @Override
        protected ForgottenHighlandsNoiseData prepare(int chunkX, int chunkZ) {
            return new ForgottenHighlandsNoiseData(chunkX, chunkZ, this.noiseScaleFactorXZ, this.noiseScaleFactorY, this.noiseSampleCountXZ, this.noiseSampleCountY);
        }

        @Override
        protected void generate(ForgottenHighlandsNoiseData data, int x, int y, int z, double worldX, double worldY, double worldZ) {
            double nx = (worldX + this.minX + this.offset) / this.scaleXZ;
            double ny = (worldY + this.offset) / this.scaleY;
            double nz = (worldZ + this.minZ + this.offset) / this.scaleXZ;
            double distX = Math.abs((this.centerX - worldX) * (1.0 / this.radiusX));
            double distY = Math.abs((this.centerY - worldY) * (1.0 / this.radiusY));
            double distZ = Math.abs((this.centerZ - worldZ) * (1.0 / this.radiusZ));
            double dist = Math.sqrt(distX * distX + distY * distY + distZ * distZ);
            double sample = NoiseUtil.genNoise(this.noise, nx, ny, nz);
            double height = sample - this.offset;
            data.samples.set(x, y, z, (float)(height + 1.0 - dist));
        }
    }
}

