/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.island;

import com.gildedgames.aether.api.world.noise.INoiseTransformer;
import com.gildedgames.orbis.lib.util.mc.NBT;
import net.minecraft.nbt.NBTTagCompound;

public class IslandVariables
implements NBT {
    private int coastHeight = 2;
    private double coastSpread;
    private double lakeScale = 65.0;
    private double lakeBlendRange = 0.5;
    private double lakeThreshold = 0.2;
    private int lakeDepth = 25;
    private int maxTerrainHeight = 80;
    private boolean terraces = true;
    private double lakeConcentrationModifier = 0.0;
    private boolean snowCaps;
    private INoiseTransformer heightSampleFilter = heightSample -> heightSample;
    private boolean magneticPillars;
    private MaxYFilter maxYFilter = (bottomMaxY, filteredSample, cutoffPoint) -> bottomMaxY + (filteredSample - cutoffPoint) * (double)this.getMaxTerrainHeight();
    private INoiseTransformer lakeBottomValueFilter = lakeBottomValue -> lakeBottomValue;

    private IslandVariables() {
    }

    public static IslandVariables build() {
        return new IslandVariables();
    }

    public INoiseTransformer getLakeBottomValueFilter() {
        return this.lakeBottomValueFilter;
    }

    public MaxYFilter getMaxYFilter() {
        return this.maxYFilter;
    }

    public boolean hasSnowCaps() {
        return this.snowCaps;
    }

    public INoiseTransformer getHeightSampleFilter() {
        return this.heightSampleFilter;
    }

    public double getLakeConcentrationModifier() {
        return this.lakeConcentrationModifier;
    }

    public int getLakeDepth() {
        return this.lakeDepth;
    }

    public boolean hasTerraces() {
        return this.terraces;
    }

    public int getMaxTerrainHeight() {
        return this.maxTerrainHeight;
    }

    public double getLakeThreshold() {
        return this.lakeThreshold;
    }

    public double getLakeBlendRange() {
        return this.lakeBlendRange;
    }

    public double getLakeScale() {
        return this.lakeScale;
    }

    public int getCoastHeight() {
        return this.coastHeight;
    }

    public double getCoastSpread() {
        return this.coastSpread;
    }

    public boolean hasMagneticPillars() {
        return this.magneticPillars;
    }

    public IslandVariables coastHeight(int coastHeight) {
        this.coastHeight = coastHeight;
        return this;
    }

    public IslandVariables coastSpread(double coastSpread) {
        this.coastSpread = coastSpread;
        return this;
    }

    public IslandVariables lakeScale(double lakeScale) {
        this.lakeScale = lakeScale;
        return this;
    }

    public IslandVariables lakeBlendRange(double lakeBlendRange) {
        this.lakeBlendRange = lakeBlendRange;
        return this;
    }

    public IslandVariables lakeThreshold(double lakeThreshold) {
        this.lakeThreshold = lakeThreshold;
        return this;
    }

    public IslandVariables maxTerrainHeight(int maxTerrainHeight) {
        this.maxTerrainHeight = maxTerrainHeight;
        return this;
    }

    public IslandVariables terraces(boolean terraces) {
        this.terraces = terraces;
        return this;
    }

    public IslandVariables lakeDepth(int lakeDepth) {
        this.lakeDepth = lakeDepth;
        return this;
    }

    public IslandVariables lakeConcentrationModifier(double lakeConcentrationModifier) {
        this.lakeConcentrationModifier = lakeConcentrationModifier;
        return this;
    }

    public IslandVariables heightSampleFilter(INoiseTransformer heightSampleFilter) {
        this.heightSampleFilter = heightSampleFilter;
        return this;
    }

    public IslandVariables snowCaps(boolean snowCaps) {
        this.snowCaps = snowCaps;
        return this;
    }

    public IslandVariables magneticPillars(boolean magneticPillars) {
        this.magneticPillars = magneticPillars;
        return this;
    }

    public IslandVariables maxYFilter(MaxYFilter maxYFilter) {
        this.maxYFilter = maxYFilter;
        return this;
    }

    public IslandVariables lakeBottomValueFilter(INoiseTransformer lakeBottomValueFilter) {
        this.lakeBottomValueFilter = lakeBottomValueFilter;
        return this;
    }

    public void write(NBTTagCompound tag) {
        tag.func_74768_a("coastHeight", this.coastHeight);
        tag.func_74780_a("coastSpread", this.coastSpread);
        tag.func_74780_a("lakeScale", this.lakeScale);
        tag.func_74780_a("lakeBlendRange", this.lakeBlendRange);
        tag.func_74780_a("lakeThreshold", this.lakeThreshold);
        tag.func_74768_a("maxTerrainHeight", this.maxTerrainHeight);
        tag.func_74757_a("terraces", this.terraces);
        tag.func_74768_a("lakeDepth", this.lakeDepth);
    }

    public void read(NBTTagCompound tag) {
        this.coastHeight = tag.func_74762_e("coastHeight");
        this.coastSpread = tag.func_74769_h("coastSpread");
        this.lakeScale = tag.func_74769_h("lakeScale");
        this.lakeBlendRange = tag.func_74769_h("lakeBlendRange");
        this.lakeThreshold = tag.func_74769_h("lakeThreshold");
        this.maxTerrainHeight = tag.func_74762_e("maxTerrainHeight");
        this.terraces = tag.func_74767_n("terraces");
        this.lakeDepth = tag.func_74762_e("lakeDepth");
    }

    public static interface MaxYFilter {
        public double transform(double var1, double var3, double var5);
    }
}

