/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.island;

import com.gildedgames.aether.api.world.decoration.WorldDecoration;
import com.gildedgames.aether.api.world.generation.caves.ICaveSystemGenerator;
import com.gildedgames.aether.api.world.islands.IIslandBounds;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.islands.IIslandGenerator;
import com.gildedgames.aether.api.world.preparation.IPrepSectorData;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.decorations.caves.VanillaCaveSystemGenerator;
import com.gildedgames.aether.common.world.island.IslandBounds;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.PlacedBlueprint;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.util.ChunkMap;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;

public class IslandData
implements IIslandData {
    private final IPrepSectorData parent;
    private BlockPos respawnPoint;
    private long seed;
    private List<NBT> components = Lists.newArrayList();
    private IIslandGenerator generator;
    private List<WorldDecoration> basicDecorations;
    private List<WorldDecoration> treeDecorations;
    private float forestTreeCountModifier;
    private float openAreaDecorationGenChance;
    private ChunkMap<List<PlacedBlueprint>> placedBlueprints = new ChunkMap();
    private IIslandBounds bounds;
    private BiomeAetherBase biome;
    private ICaveSystemGenerator caveSystemGenerator;

    public IslandData(IPrepSectorData parent, IIslandBounds bounds, BiomeAetherBase biome, long seed) {
        this.parent = parent;
        this.seed = seed;
        this.bounds = bounds;
        this.biome = biome;
        this.initProperties(new Random(seed));
    }

    public IslandData(IPrepSectorData parent, NBTTagCompound tag) {
        this.parent = parent;
        this.read(tag);
    }

    private void initProperties(Random rand) {
        this.generator = this.biome.createIslandGenerator(rand, this);
        this.basicDecorations = this.biome.createBasicDecorations(rand);
        this.treeDecorations = this.biome.createTreeDecorations(rand);
        this.forestTreeCountModifier = this.biome.createForestTreeCountModifier(rand);
        this.openAreaDecorationGenChance = this.biome.createOpenAreaDecorationGenChance(rand);
        this.caveSystemGenerator = new VanillaCaveSystemGenerator(this.seed);
    }

    @Override
    public <T extends NBT> void addComponents(Collection<T> components) {
        this.components.addAll(components);
    }

    @Override
    public Collection<NBT> getComponents() {
        return this.components;
    }

    @Override
    public List<WorldDecoration> getBasicDecorations() {
        return this.basicDecorations;
    }

    @Override
    public List<WorldDecoration> getTreeDecorations() {
        return this.treeDecorations;
    }

    @Override
    public float getForestTreeCountModifier() {
        return this.forestTreeCountModifier;
    }

    @Override
    public float getOpenAreaDecorationGenChance() {
        return this.openAreaDecorationGenChance;
    }

    @Override
    @Nonnull
    public IIslandGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public BlockPos getOutpostPos() {
        return this.respawnPoint;
    }

    @Override
    public void setOutpostPos(BlockPos pos) {
        this.respawnPoint = pos;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public PlacedBlueprint placeBlueprint(BakedBlueprint baked, BlockPos offset) {
        ICreationData data = baked.getCreationData().clone();
        data.pos(offset);
        PlacedBlueprint instance = new PlacedBlueprint(baked, data);
        for (ChunkPos pos : baked.getOccupiedChunks(offset)) {
            if (!this.placedBlueprints.containsKey(pos.field_77276_a, pos.field_77275_b)) {
                this.placedBlueprints.put(pos.field_77276_a, pos.field_77275_b, (Object)Lists.newArrayList());
            }
            ((List)this.placedBlueprints.get(pos.field_77276_a, pos.field_77275_b)).add(instance);
        }
        return instance;
    }

    @Override
    public List<PlacedBlueprint> getPlacedBlueprintsInChunk(int chunkX, int chunkZ) {
        if (!this.placedBlueprints.containsKey(chunkX, chunkZ)) {
            return Collections.emptyList();
        }
        return (List)this.placedBlueprints.get(chunkX, chunkZ);
    }

    @Override
    @Nonnull
    public IIslandBounds getBounds() {
        return this.bounds;
    }

    @Override
    @Nonnull
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    @Nonnull
    public ICaveSystemGenerator getCaveSystemGenerator() {
        return this.caveSystemGenerator;
    }

    @Override
    public void tick() {
    }

    @Override
    public IPrepSectorData getParentSectorData() {
        return this.parent;
    }

    public void write(NBTTagCompound tag) {
        tag.func_74782_a("Bounds", this.bounds.serialize());
        tag.func_74778_a("BiomeID", this.biome.getRegistryName().toString());
        tag.func_74772_a("Seed", this.seed);
        tag.func_74782_a("RespawnPoint", NBTHelper.writeBlockPos((BlockPos)this.respawnPoint));
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setLongMap("placedBlueprints", this.placedBlueprints.getInnerMap(), NBTFunnel.listSetter());
        funnel.setList("Components", this.components);
    }

    public void read(NBTTagCompound tag) {
        this.bounds = new IslandBounds((NBTBase)tag.func_74775_l("Bounds"));
        this.biome = (BiomeAetherBase)((Object)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("BiomeID"))));
        NBTFunnel funnel = new NBTFunnel(tag);
        this.seed = tag.func_74763_f("Seed");
        if (tag.func_74764_b("RespawnPoint")) {
            this.respawnPoint = NBTHelper.readBlockPos((NBTTagCompound)tag.func_74775_l("RespawnPoint"));
        }
        this.placedBlueprints = ChunkMap.createFrom((Long2ObjectOpenHashMap)funnel.getLongMap("placedBlueprints", NBTFunnel.listGetter()));
        this.components = funnel.getList("Components");
        Random rand = new Random(this.seed);
        this.initProperties(rand);
    }
}

