/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.island;

import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.preparation.IChunkMask;
import com.gildedgames.aether.api.world.preparation.IPrepRegistryEntry;
import com.gildedgames.aether.api.world.preparation.IPrepSectorData;
import com.gildedgames.aether.common.world.access.BlockAccessPrep;
import com.gildedgames.orbis.lib.core.PlacedBlueprint;
import com.gildedgames.orbis.lib.util.mc.BlockUtil;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockAccessIsland
extends BlockAccessPrep {
    private final IIslandData island;

    public BlockAccessIsland(World world, IIslandData island, IPrepSectorData sectorData, IPrepRegistryEntry registryEntry) {
        super(world, sectorData, registryEntry);
        this.island = island;
    }

    public boolean canAccess(BlockPos pos) {
        return this.island.getBounds().contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean canAccess(int x, int z) {
        return this.island.getBounds().contains(x, 0, z);
    }

    public boolean canAccess(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.island.getBounds().contains(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public IBlockState func_180495_p(BlockPos pos) {
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        List<PlacedBlueprint> placedBlueprints = this.island.getPlacedBlueprintsInChunk(chunkX, chunkZ);
        for (PlacedBlueprint placed : placedBlueprints) {
            if (!placed.getRegion().contains(pos)) continue;
            BlockPos min = placed.getRegion().getMin();
            IBlockState state = placed.getBaked().getBlockData().getBlockState(pos.func_177958_n() - min.func_177958_n(), pos.func_177956_o() - min.func_177956_o(), pos.func_177952_p() - min.func_177952_p());
            if (BlockUtil.isVoid((IBlockState)state)) continue;
            return state;
        }
        IChunkMask chunk = this.getChunk(chunkX, chunkZ);
        return this.transformer.getBlockState(chunk.getBlock(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF));
    }
}

