/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.instances.necromancer_tower;

import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.init.GenerationAether;
import com.gildedgames.aether.common.init.InstancesAether;
import com.gildedgames.orbis.lib.core.CreationData;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.PlacedBlueprint;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.world.instances.IInstance;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class NecromancerTowerInstance
implements IInstance {
    private final List<EntityPlayer> players = Lists.newArrayList();
    private BlockPos insideEntrance;
    private int dimensionId;
    private PlacedBlueprint tower;

    public NecromancerTowerInstance() {
    }

    public NecromancerTowerInstance(World world) {
    }

    public NecromancerTowerInstance(int id) {
        this.dimensionId = id;
    }

    private boolean initTower() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = server.func_71218_a(this.dimensionId);
        if (world == null) {
            return false;
        }
        BakedBlueprint baked = new BakedBlueprint(GenerationAether.NECROMANCER_TOWER, (ICreationData)new CreationData((World)world).pos(BlockPos.field_177992_a));
        this.tower = new PlacedBlueprint(baked, baked.getCreationData());
        BlockPos spawn = this.tower.getBaked().getScheduleFromTriggerID("spawn").getBounds().getMin();
        if (spawn != null) {
            this.insideEntrance = new BlockPosDimension(spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p(), this.dimensionId);
        }
        return true;
    }

    public PlacedBlueprint getTower() {
        if (this.tower == null) {
            this.initTower();
        }
        return this.tower;
    }

    public void write(NBTTagCompound output) {
        NBTFunnel funnel = new NBTFunnel(output);
        output.func_74782_a("spawn", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.insideEntrance));
        output.func_74768_a("dim", this.dimensionId);
        funnel.set("tower", (NBT)this.tower);
    }

    public void read(NBTTagCompound input) {
        NBTFunnel funnel = new NBTFunnel(input);
        this.insideEntrance = NBTUtil.func_186861_c((NBTTagCompound)input.func_74775_l("spawn"));
        this.dimensionId = input.func_74762_e("dim");
        this.tower = (PlacedBlueprint)funnel.get("tower");
    }

    public void onJoin(EntityPlayer player) {
        this.players.add(player);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (playerMP.field_71134_c.func_73081_b() == GameType.SURVIVAL) {
                player.func_71033_a(GameType.ADVENTURE);
                player.func_184224_h(true);
            }
            this.teleportPlayerToSpawn(player);
        }
    }

    public void onLeave(EntityPlayer player) {
        this.players.remove(player);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (playerMP.field_71134_c.func_73081_b() == GameType.ADVENTURE) {
                player.func_71033_a(GameType.SURVIVAL);
                player.func_184224_h(false);
            }
        }
        if (this.players.isEmpty()) {
            InstancesAether.NECROMANCER_TOWER_HANDLER.handler.unregisterInstance((IInstance)this);
        }
    }

    public void onRespawn(EntityPlayer player) {
        this.teleportPlayerToSpawn(player);
    }

    private void teleportPlayerToSpawn(EntityPlayer player) {
        BlockPos spawn = this.getSpawnPosition();
        if (spawn != null) {
            ((EntityPlayerMP)player).field_71135_a.func_147364_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.5, (double)spawn.func_177952_p() + 0.5, 215.0f, 0.0f);
        }
    }

    public BlockPos getSpawnPosition() {
        return this.insideEntrance;
    }

    public List<EntityPlayer> getPlayers() {
        return this.players;
    }

    public DimensionType getDimensionType() {
        return DimensionsAether.NECROMANCER_TOWER;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public boolean isTemporary() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NecromancerTowerInstance) {
            NecromancerTowerInstance instance = (NecromancerTowerInstance)obj;
            return instance.getDimensionId() == this.getDimensionId();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.dimensionId);
        return builder.toHashCode();
    }
}

