/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.generators;

import com.gildedgames.aether.api.world.IChunkInfoAether;
import com.gildedgames.aether.api.world.islands.IIslandChunkInfo;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.preparation.IChunkMask;
import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.common.util.helpers.IslandHelper;
import com.gildedgames.aether.common.world.WorldProviderAether;
import com.gildedgames.aether.common.world.access.BlockAccessChunkDataContainer;
import com.gildedgames.aether.common.world.aether.ChunkInfoAether;
import com.gildedgames.aether.common.world.aether.WorldPreparationAether;
import com.gildedgames.aether.common.world.preparation.mask.ChunkDataContainer;
import com.gildedgames.aether.common.world.preparation.mask.ChunkMask;
import com.gildedgames.orbis.lib.core.PlacedBlueprint;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.processing.DataPrimer;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.gildedgames.orbis.lib.util.random.XoRoShiRoRandom;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorAether
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private final WorldPreparationAether preparation;

    public ChunkGeneratorAether(World world, long seed) {
        this.world = world;
        if (!this.world.field_72995_K) {
            this.world.func_181544_b(0);
        }
        this.rand = new XoRoShiRoRandom(seed);
        this.preparation = new WorldPreparationAether(this.world, WorldProviderAether.get(world).getNoise());
    }

    public WorldPreparationAether getPreparation() {
        return this.preparation;
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        IIslandData islandData = IslandHelper.get(this.world, chunkX, chunkZ);
        if (islandData == null) {
            return new Chunk(this.world, chunkX, chunkZ);
        }
        ChunkInfoAether info = new ChunkInfoAether(1);
        info.setIslandData(0, this.generateChunkColumnInfo(islandData, chunkX, chunkZ));
        ChunkMask mask = new ChunkMask(chunkX, chunkZ);
        this.preparation.generateFull(info, mask, islandData, chunkX, chunkZ, this.world.func_72905_C());
        IChunkMaskTransformer transformer = islandData.getGenerator().createMaskTransformer(islandData, chunkX, chunkZ);
        ChunkDataContainer data = ChunkDataContainer.createFromMask(this.world, mask, transformer, chunkX, chunkZ);
        BlockAccessChunkDataContainer blockAccess = new BlockAccessChunkDataContainer(this.world, data);
        DataPrimer dataPrimer = new DataPrimer((IBlockAccessExtended)blockAccess);
        Region region = new Region(new BlockPos(chunkX * 16, 0, chunkZ * 16), new BlockPos(chunkX * 16, 255, chunkZ * 16).func_177982_a(15, 15, 15));
        for (PlacedBlueprint instance : islandData.getPlacedBlueprintsInChunk(chunkX, chunkZ)) {
            dataPrimer.place(instance, (IRegion)region);
        }
        return data.createChunk(this.world, chunkX, chunkZ);
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        IIslandData island = IslandHelper.get(this.world, chunkX, chunkZ);
        if (island == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, false));
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.world.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long seedX = this.rand.nextLong() / 2L * 2L + 1L;
        long seedZ = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * seedX + (long)chunkZ * seedZ ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, pos);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.world.func_180494_b(pos);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void generateBaseTerrain(IChunkInfoAether info, IChunkMask mask, IIslandData islandData, int x, int z) {
        this.preparation.generateBaseTerrain(info, mask, islandData, x, z, this.world.func_72905_C());
    }

    public IIslandChunkInfo generateChunkColumnInfo(IIslandData islandData, int chunkX, int chunkZ) {
        return this.preparation.generateChunkColumnInfo(islandData, chunkX, chunkZ);
    }
}

