/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.decorations.plants;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.orbis.lib.util.ArrayHelper;
import com.gildedgames.orbis.lib.world.WorldSlice;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class WorldGenFoliage {
    private final IBlockState[] states;
    private final int max;
    private IBlockState[] statesCanPlaceOn = new IBlockState[]{BlocksAether.aether_grass.func_176223_P()};

    public WorldGenFoliage(int max, IBlockState ... states) {
        if (states.length == 0) {
            throw new IllegalArgumentException("At least one state must be specified");
        }
        this.max = max;
        this.states = states;
    }

    public void setStatesToPlaceOn(IBlockState ... states) {
        this.statesCanPlaceOn = states;
    }

    public boolean generate(WorldSlice slice, Random rand, int x, int z) {
        BlockPos pos = slice.getHighestBlockPos(x, z);
        BlockPos.MutableBlockPos randomPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos randomPosDown = new BlockPos.MutableBlockPos();
        for (int attempts = 0; attempts < this.max; ++attempts) {
            randomPos.func_181079_c(pos.func_177958_n() + (rand.nextInt(16) - 8), pos.func_177956_o() + (rand.nextInt(8) - 4), pos.func_177952_p() + (rand.nextInt(16) - 8));
            if (!slice.isAirBlock((BlockPos)randomPos)) continue;
            randomPosDown.func_181079_c(randomPos.func_177958_n(), randomPos.func_177956_o() - 1, randomPos.func_177952_p());
            IBlockState below = slice.getBlockState((BlockPos)randomPosDown);
            if (!ArrayHelper.contains((Object[])this.statesCanPlaceOn, (Object)below)) continue;
            IBlockState chosen = this.states.length == 1 ? this.states[0] : this.states[rand.nextInt(this.states.length)];
            slice.setBlockState((BlockPos)randomPos, chosen);
        }
        return true;
    }
}

