/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.decorations.caves;

import com.gildedgames.aether.api.world.generation.caves.CaveSystemNode;
import com.gildedgames.aether.api.world.generation.caves.CaveSystemTunnel;
import com.gildedgames.aether.api.world.generation.caves.ICaveSystemGenerator;
import com.gildedgames.aether.common.world.island.IslandBlockType;
import com.gildedgames.aether.common.world.preparation.mask.ChunkMask;
import com.gildedgames.aether.common.world.preparation.mask.ChunkMaskSegment;
import net.minecraft.util.math.MathHelper;

public class WorldGenAetherCaves {
    private void tryCarveTunnel(ChunkMask mask, CaveSystemNode node, double chunkBlockCenterX, double chunkBlockCenterZ, int centerChunkX, int centerChunkZ) {
        double chunkMaxY = mask.getMaxYSegment() * 8 + 8;
        double chunkMinY = mask.getMinYSegment() * 8;
        for (CaveSystemTunnel segment : node.entries) {
            double d4 = segment.posX - chunkBlockCenterX;
            double d5 = segment.posZ - chunkBlockCenterZ;
            double nodesLeft = segment.nodesLeft;
            double d7 = segment.nodeSizeMultiplier + 18.0;
            if (d4 * d4 + d5 * d5 - nodesLeft * nodesLeft > d7 * d7) {
                return;
            }
            if (segment.posY - segment.nodeHeightRadius - 1.0 > chunkMaxY || segment.posY + segment.nodeHeightRadius + 1.0 < chunkMinY || !(segment.posX >= chunkBlockCenterX - 16.0 - segment.nodeWidthRadius * 2.0) || !(segment.posZ >= chunkBlockCenterZ - 16.0 - segment.nodeWidthRadius * 2.0) || !(segment.posX <= chunkBlockCenterX + 16.0 + segment.nodeWidthRadius * 2.0) || !(segment.posZ <= chunkBlockCenterZ + 16.0 + segment.nodeWidthRadius * 2.0)) continue;
            int minPosX = MathHelper.func_76128_c((double)(segment.posX - segment.nodeWidthRadius)) - centerChunkX * 16 - 1;
            int maxPosX = MathHelper.func_76128_c((double)(segment.posX + segment.nodeWidthRadius)) - centerChunkX * 16 + 1;
            int minPosY = MathHelper.func_76128_c((double)(segment.posY - segment.nodeHeightRadius)) - 1;
            int maxPosY = MathHelper.func_76128_c((double)(segment.posY + segment.nodeHeightRadius)) + 1;
            int minPosZ = MathHelper.func_76128_c((double)(segment.posZ - segment.nodeWidthRadius)) - centerChunkZ * 16 - 1;
            int maxPosZ = MathHelper.func_76128_c((double)(segment.posZ + segment.nodeWidthRadius)) - centerChunkZ * 16 + 1;
            if (minPosX < 0) {
                minPosX = 0;
            }
            if (maxPosX > 16) {
                maxPosX = 16;
            }
            if (minPosY < 1) {
                minPosY = 1;
            }
            if (maxPosY > 248) {
                maxPosY = 248;
            }
            if (minPosZ < 0) {
                minPosZ = 0;
            }
            if (maxPosZ > 16) {
                maxPosZ = 16;
            }
            if (!this.carveTunnel(mask, centerChunkX, centerChunkZ, segment, minPosX, maxPosX, minPosY, maxPosY, minPosZ, maxPosZ)) continue;
            return;
        }
        for (CaveSystemNode branch : node.branches) {
            this.tryCarveTunnel(mask, branch, chunkBlockCenterX, chunkBlockCenterZ, centerChunkX, centerChunkZ);
        }
    }

    private boolean carveTunnel(ChunkMask mask, int centerChunkX, int centerChunkZ, CaveSystemTunnel segment, int minPosX, int maxPosX, int minPosY, int maxPosY, int minPosZ, int maxPosZ) {
        boolean doesNodeIntersectWater = false;
        block0: for (int x = minPosX; x < maxPosX; ++x) {
            boolean a = x != minPosX && x != maxPosX - 1;
            for (int z = minPosZ; z < maxPosZ; ++z) {
                boolean b = z != minPosZ && z != maxPosZ - 1;
                for (int y = maxPosY + 1; y >= minPosY - 1; --y) {
                    int block;
                    if (y != minPosY - 1 && a && b) {
                        y = minPosY;
                    }
                    if ((block = mask.getBlock(x, y, z)) != IslandBlockType.WATER_BLOCK.ordinal() && block != IslandBlockType.COAST_BLOCK.ordinal()) continue;
                    doesNodeIntersectWater = true;
                    break block0;
                }
            }
        }
        if (!doesNodeIntersectWater) {
            double wStep = 1.0 / segment.nodeWidthRadius;
            double hStep = 1.0 / segment.nodeHeightRadius;
            double distX = ((double)(minPosX + centerChunkX * 16) + 0.5 - segment.posX) * wStep;
            for (int x = minPosX; x < maxPosX; ++x) {
                double distXSq = distX * distX;
                if (distXSq < 1.0) {
                    double distZ = ((double)(minPosZ + centerChunkZ * 16) + 0.5 - segment.posZ) * wStep;
                    for (int z = minPosZ; z < maxPosZ; ++z) {
                        double distZSq = distZ * distZ;
                        if (distXSq + distZSq < 1.0) {
                            double distY = ((double)maxPosY - 0.5 - segment.posY) * hStep;
                            for (int y = maxPosY; y > minPosY; --y) {
                                double distYSq = distY * distY;
                                if (distYSq + distXSq + distZSq < 1.0) {
                                    this.digBlock(mask, x, y, z);
                                }
                                distY -= hStep;
                            }
                        }
                        distZ += wStep;
                    }
                }
                distX += wStep;
            }
            return segment.isRoom;
        }
        return false;
    }

    private void digBlock(ChunkMask mask, int x, int y, int z) {
        int block;
        ChunkMaskSegment segment = mask.getSegment(y >> 3);
        if (segment != null && ((block = segment.getBlock(x, y & 7, z)) == IslandBlockType.STONE_BLOCK.ordinal() || block == IslandBlockType.STONE_MOSSY_BLOCK.ordinal())) {
            segment.setBlock(x, y & 7, z, IslandBlockType.AIR_BLOCK.ordinal());
        }
    }

    public void generate(ICaveSystemGenerator generator, int centerChunkX, int centerChunkZ, ChunkMask mask) {
        int i = generator.getNeighborChunkSearchRadius();
        for (int chunkX = centerChunkX - i; chunkX <= centerChunkX + i; ++chunkX) {
            for (int chunkZ = centerChunkZ - i; chunkZ <= centerChunkZ + i; ++chunkZ) {
                CaveSystemNode tree = generator.getNode(chunkX, chunkZ);
                this.tryCarveTunnel(mask, tree, centerChunkX * 16 + 8, centerChunkZ * 16 + 8, centerChunkX, centerChunkZ);
            }
        }
    }
}

