/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.decorations.caves;

import com.gildedgames.aether.api.world.generation.caves.CaveSystemNode;
import com.gildedgames.aether.api.world.generation.caves.CaveSystemTunnel;
import com.gildedgames.aether.api.world.generation.caves.ICaveSystemGenerator;
import com.gildedgames.orbis.lib.util.ChunkMap;
import com.gildedgames.orbis.lib.util.random.XoRoShiRoRandom;
import net.minecraft.util.math.MathHelper;

public class VanillaCaveSystemGenerator
implements ICaveSystemGenerator {
    private final ChunkMap<CaveSystemNode> cache = new ChunkMap();
    private final long seed;
    private final long s1;
    private final long s2;

    public VanillaCaveSystemGenerator(long seed) {
        this.seed = seed;
        XoRoShiRoRandom r = new XoRoShiRoRandom(this.seed);
        this.s1 = r.nextLong();
        this.s2 = r.nextLong();
    }

    private void addRoom(CaveSystemNode node, XoRoShiRoRandom rand, long seed, double dirX, double dirY, double dirZ) {
        this.addTunnel(node, seed, dirX, dirY, dirZ, 1.0f + rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    private void addTunnel(CaveSystemNode segment, long seed, double posX, double posY, double posZ, float nodeSizeMultiplier, float angleBetweenNodes, float distBetweenNodes, int nodeIndex, int noOfNodes, double startingNodeHeightMult) {
        boolean higherDist;
        float nodeAngleMult = 0.0f;
        float nodeDistMult = 0.0f;
        boolean isRoom = false;
        XoRoShiRoRandom random = new XoRoShiRoRandom(seed);
        if (noOfNodes <= 0) {
            int i = this.getNeighborChunkSearchRadius() * 16 - 16;
            noOfNodes = i - random.nextInt(i / 4);
        }
        if (nodeIndex == -1) {
            nodeIndex = noOfNodes / 2;
            isRoom = true;
        }
        int branchNodeIndex = random.nextInt(noOfNodes / 2) + noOfNodes / 4;
        boolean bl = higherDist = random.nextInt(6) == 0;
        while (nodeIndex < noOfNodes) {
            double nodeWidthRadius = 1.5 + (double)MathHelper.func_76126_a((float)((float)nodeIndex * (float)Math.PI / (float)noOfNodes)) * (double)nodeSizeMultiplier;
            double nodeHeightRadius = nodeWidthRadius * startingNodeHeightMult;
            float nodeDistMultiplier = MathHelper.func_76134_b((float)distBetweenNodes);
            float nodeYIncrease = MathHelper.func_76126_a((float)distBetweenNodes);
            posX += (double)(MathHelper.func_76134_b((float)angleBetweenNodes) * nodeDistMultiplier);
            posY += (double)nodeYIncrease;
            posZ += (double)(MathHelper.func_76126_a((float)angleBetweenNodes) * nodeDistMultiplier);
            distBetweenNodes *= higherDist ? 0.92f : 0.7f;
            distBetweenNodes += nodeDistMult * 0.1f;
            angleBetweenNodes += nodeAngleMult * 0.1f;
            nodeDistMult *= 0.9f;
            nodeAngleMult *= 0.75f;
            nodeDistMult += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            nodeAngleMult += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!isRoom && nodeIndex == branchNodeIndex && nodeSizeMultiplier > 1.0f && noOfNodes > 0) {
                this.addTunnel(segment.addBranch(), random.nextLong(), posX, posY, posZ, random.nextFloat() * 0.5f + 0.5f, angleBetweenNodes - 1.5707964f, distBetweenNodes / 3.0f, nodeIndex, noOfNodes, 1.0);
                this.addTunnel(segment.addBranch(), random.nextLong(), posX, posY, posZ, random.nextFloat() * 0.5f + 0.5f, angleBetweenNodes + 1.5707964f, distBetweenNodes / 3.0f, nodeIndex, noOfNodes, 1.0);
                return;
            }
            if (isRoom || random.nextInt(4) != 0) {
                segment.entries.add(new CaveSystemTunnel(posX, posY, posZ, isRoom, nodeWidthRadius, nodeHeightRadius, nodeSizeMultiplier, noOfNodes, nodeIndex));
            }
            ++nodeIndex;
        }
    }

    @Override
    public CaveSystemNode getNode(int chunkX, int chunkZ) {
        CaveSystemNode root = (CaveSystemNode)this.cache.get(chunkX, chunkZ);
        if (root != null) {
            return root;
        }
        root = this.generateNode(chunkX, chunkZ);
        this.cache.put(chunkX, chunkZ, (Object)root);
        return root;
    }

    private CaveSystemNode generateNode(int chunkX, int chunkZ) {
        CaveSystemNode root = new CaveSystemNode();
        long j1 = (long)chunkX * this.s1;
        long k1 = (long)chunkZ * this.s2;
        XoRoShiRoRandom rand = new XoRoShiRoRandom(j1 ^ k1 ^ this.seed);
        int tunnelsPerChunk = rand.nextInt(rand.nextInt(rand.nextInt(10) + 1) + 1);
        if (rand.nextInt(5) != 0) {
            tunnelsPerChunk = 0;
        }
        for (int j = 0; j < tunnelsPerChunk; ++j) {
            double x = chunkX * 16 + rand.nextInt(16);
            double y = rand.nextInt(128);
            double z = chunkZ * 16 + rand.nextInt(16);
            int tunnels = 2;
            if (rand.nextInt(4) == 0) {
                this.addRoom(root.addBranch(), rand, rand.nextLong(), x, y, z);
                tunnels += rand.nextInt(4);
            }
            for (int l = 0; l < tunnels; ++l) {
                float nodeAngle = rand.nextFloat() * ((float)Math.PI * 2);
                float nodeDist = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float nodeSize = rand.nextFloat() * 2.0f + rand.nextFloat();
                if (rand.nextInt(10) == 0) {
                    nodeSize *= rand.nextFloat() * rand.nextFloat() * 3.0f + 1.0f;
                }
                this.addTunnel(root.addBranch(), rand.nextLong(), x, y, z, nodeSize * 2.0f, nodeAngle, nodeDist, 0, 0, 0.5);
            }
        }
        return root;
    }

    @Override
    public int getNeighborChunkSearchRadius() {
        return 8;
    }
}

