/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.decorations.aerclouds;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.decoration.WorldDecorationGenerator;
import com.gildedgames.orbis.lib.world.WorldSlice;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenAercloud
implements WorldDecorationGenerator {
    protected final IBlockState state;
    protected final int numberOfBlocks;
    protected final boolean isFlat;

    public WorldGenAercloud(IBlockState state, int numberOfBlocks, boolean isFlat) {
        this.state = state;
        this.numberOfBlocks = numberOfBlocks;
        this.isFlat = isFlat;
    }

    public IBlockState getAercloudState(Random random) {
        return this.state;
    }

    @Override
    public boolean generate(WorldSlice slice, Random rand, BlockPos pos) {
        World world = slice.getWorld();
        IBlockState state = this.getAercloudState(rand);
        BlockPos.MutableBlockPos posMut = new BlockPos.MutableBlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        int x = pos.func_177958_n() + 8;
        int y = pos.func_177956_o();
        int z = pos.func_177952_p() + 8;
        int xTendency = rand.nextInt(3) - 1;
        int zTendency = rand.nextInt(3) - 1;
        ArrayList<BlockPos> transaction = new ArrayList<BlockPos>(this.numberOfBlocks);
        for (int n = 0; n < this.numberOfBlocks; ++n) {
            x += rand.nextInt(3) - 1 + xTendency;
            if (rand.nextBoolean() && !this.isFlat || this.isFlat && rand.nextInt(10) == 0) {
                y += rand.nextInt(3) - 1;
            }
            z += rand.nextInt(3) - 1 + zTendency;
            for (int x1 = x; x1 < x + rand.nextInt(4) + 3 * (this.isFlat ? 3 : 1); ++x1) {
                for (int z1 = z; z1 < z + rand.nextInt(4) + 3 * (this.isFlat ? 3 : 1); ++z1) {
                    posMut.func_181079_c(x1, 0, z1);
                    int height = world.func_175726_f((BlockPos)posMut).func_177433_f((BlockPos)posMut);
                    int maxY = y + rand.nextInt(1) + 2;
                    if (height >= maxY && world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos(x1, height - 1, z1)).func_177230_c() != BlocksAether.aercloud) {
                        return false;
                    }
                    for (int y1 = y; y1 < maxY; ++y1) {
                        posMut.func_181079_c(x1, y1, z1);
                        if (!world.func_175697_a((BlockPos)posMut, 2)) {
                            return false;
                        }
                        if (world.func_180495_p((BlockPos)posMut) != Blocks.field_150350_a.func_176223_P() || Math.abs(x1 - x) + Math.abs(y1 - y) + Math.abs(z1 - z) >= 4 * (this.isFlat ? 3 : 1) + rand.nextInt(2)) continue;
                        transaction.add(posMut.func_185334_h());
                    }
                }
            }
        }
        for (BlockPos block : transaction) {
            world.func_180501_a(block, state, 18);
        }
        return true;
    }
}

