/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.decorations;

import com.gildedgames.aether.common.world.island.IslandBlockType;
import com.gildedgames.aether.common.world.preparation.mask.ChunkMask;
import com.gildedgames.orbis.lib.util.random.XoRoShiRoRandom;
import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class WorldGenUndergroundVeins {
    protected final int chunkRange = 12;
    protected final ThreadLocal<XoRoShiRoRandom> rand = ThreadLocal.withInitial(XoRoShiRoRandom::new);

    protected void addTunnel(long seed, int chunkX, int chunkZ, ChunkMask mask, double posX, double posY, double posZ, float nodeSizeMultiplier, float angleBetweenNodes, float distBetweenNodes, int nodeIndex, int noOfNodes, double startingNodeHeightMult) {
        boolean higherDist;
        double chunkBlockCenterX = chunkX * 16 + 8;
        double chunkBlockCenterZ = chunkZ * 16 + 8;
        float nodeAngleMult = 0.0f;
        float nodeDistMult = 0.0f;
        XoRoShiRoRandom random = new XoRoShiRoRandom(seed);
        if (noOfNodes <= 0) {
            int i = this.chunkRange * 16 - 16;
            noOfNodes = i - random.nextInt(i / 4);
        }
        int branchNodeIndex = random.nextInt(noOfNodes / 2) + noOfNodes / 4;
        boolean bl = higherDist = random.nextInt(6) == 0;
        while (nodeIndex < noOfNodes) {
            double nodeHeight = 1.5 + (double)(MathHelper.func_76126_a((float)((float)nodeIndex * (float)Math.PI / (float)noOfNodes)) * nodeSizeMultiplier);
            double d3 = nodeHeight * startingNodeHeightMult;
            float f2 = MathHelper.func_76134_b((float)distBetweenNodes);
            float f3 = MathHelper.func_76126_a((float)distBetweenNodes);
            posX += (double)(MathHelper.func_76134_b((float)angleBetweenNodes) * f2);
            posY += (double)f3;
            posZ += (double)(MathHelper.func_76126_a((float)angleBetweenNodes) * f2);
            distBetweenNodes *= higherDist ? 0.92f : 0.7f;
            distBetweenNodes += nodeDistMult * 0.1f;
            angleBetweenNodes += nodeAngleMult * 0.1f;
            nodeDistMult *= 0.9f;
            nodeAngleMult *= 0.75f;
            nodeDistMult += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            nodeAngleMult += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (random.nextInt(4) != 0) {
                double d4 = posX - chunkBlockCenterX;
                double d5 = posZ - chunkBlockCenterZ;
                double nodesLeft = noOfNodes - nodeIndex;
                double d7 = nodeSizeMultiplier + 18.0f;
                if (d4 * d4 + d5 * d5 - nodesLeft * nodesLeft > d7 * d7) {
                    return;
                }
                if (posX >= chunkBlockCenterX - 16.0 - nodeHeight * 2.0 && posZ >= chunkBlockCenterZ - 16.0 - nodeHeight * 2.0 && posX <= chunkBlockCenterX + 16.0 + nodeHeight * 2.0 && posZ <= chunkBlockCenterZ + 16.0 + nodeHeight * 2.0) {
                    int k2 = MathHelper.func_76128_c((double)(posX - nodeHeight)) - chunkX * 16 - 1;
                    int k = MathHelper.func_76128_c((double)(posX + nodeHeight)) - chunkX * 16 + 1;
                    int l2 = MathHelper.func_76128_c((double)(posY - d3)) - 1;
                    int l = MathHelper.func_76128_c((double)(posY + d3)) + 1;
                    int i3 = MathHelper.func_76128_c((double)(posZ - nodeHeight)) - chunkZ * 16 - 1;
                    int i1 = MathHelper.func_76128_c((double)(posZ + nodeHeight)) - chunkZ * 16 + 1;
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if (k > 16) {
                        k = 16;
                    }
                    if (l2 < 1) {
                        l2 = 1;
                    }
                    if (l > 248) {
                        l = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i1 > 16) {
                        i1 = 16;
                    }
                    boolean isBlockWater = false;
                    for (int j1 = k2; !isBlockWater && j1 < k; ++j1) {
                        for (int k1 = i3; !isBlockWater && k1 < i1; ++k1) {
                            for (int l1 = l + 1; !isBlockWater && l1 >= l2 - 1; --l1) {
                                if (l1 < 0 || l1 >= 256) continue;
                                if (this.isOceanBlock(mask, j1, l1, k1)) {
                                    isBlockWater = true;
                                }
                                if (l1 == l2 - 1 || j1 == k2 || j1 == k - 1 || k1 == i3 || k1 == i1 - 1) continue;
                                l1 = l2;
                            }
                        }
                    }
                    if (!isBlockWater) {
                        for (int j3 = k2; j3 < k; ++j3) {
                            double d10 = ((double)(j3 + chunkX * 16) + 0.5 - posX) / nodeHeight;
                            for (int i2 = i3; i2 < i1; ++i2) {
                                double d8 = ((double)(i2 + chunkZ * 16) + 0.5 - posZ) / nodeHeight;
                                boolean foundTop = false;
                                if (!(d10 * d10 + d8 * d8 < 1.0)) continue;
                                for (int j2 = l; j2 > l2; --j2) {
                                    double d9 = ((double)(j2 - 1) + 0.5 - posY) / d3;
                                    if (!(d9 > -0.7) || !(d10 * d10 + d9 * d9 + d8 * d8 < 1.0)) continue;
                                    int block = mask.getBlock(j3, j2, i2);
                                    if (this.isTopBlock(mask, j3, j2, i2)) {
                                        foundTop = true;
                                    }
                                    this.digBlock(mask, j3, j2, i2, foundTop, block);
                                }
                            }
                        }
                    }
                }
            }
            ++nodeIndex;
        }
    }

    protected boolean isOceanBlock(ChunkMask data, int x, int y, int z) {
        return data.getBlock(x, y, z) == IslandBlockType.WATER_BLOCK.ordinal();
    }

    public void generate(long seed, int x, int z, ChunkMask mask) {
        XoRoShiRoRandom rand = this.rand.get();
        rand.setSeed(seed);
        int i = this.chunkRange;
        long j = rand.nextLong();
        long k = rand.nextLong();
        for (int l = x - i; l <= x + i; ++l) {
            for (int i1 = z - i; i1 <= z + i; ++i1) {
                long j1 = (long)l * j;
                long k1 = (long)i1 * k;
                rand.setSeed(j1 ^ k1 ^ seed);
                this.recursiveGenerate(l, i1, x, z, mask);
            }
        }
    }

    private void recursiveGenerate(int chunkX, int chunkZ, int originalX, int originalZ, ChunkMask mask) {
        Random rand = (Random)this.rand.get();
        int i = rand.nextInt(rand.nextInt(rand.nextInt(10) + 1) + 1);
        if (rand.nextInt(5) != 0) {
            i = 0;
        }
        for (int j = 0; j < i; ++j) {
            double x = chunkX * 16 + rand.nextInt(16);
            double y = rand.nextInt(64);
            double z = chunkZ * 16 + rand.nextInt(16);
            int tunnels = 2;
            for (int l = 0; l < tunnels; ++l) {
                float f = rand.nextFloat() * ((float)Math.PI * 2);
                float f1 = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = rand.nextFloat() * 2.0f + rand.nextFloat();
                if (rand.nextInt(8) == 0) {
                    this.addTunnel(rand.nextLong(), originalX, originalZ, mask, x, y, z, f2, f, f1, 0, 0, 0.5);
                    tunnels += rand.nextInt(2);
                }
                if (rand.nextInt(20) == 0) {
                    f2 *= rand.nextFloat() * rand.nextFloat() * 3.0f + 1.0f;
                }
                this.addTunnel(rand.nextLong(), originalX, originalZ, mask, x, y, z, f2, f, f1, 0, 0, 0.5);
            }
        }
    }

    private boolean isTopBlock(ChunkMask data, int x, int y, int z) {
        return data.getBlock(x, y, z) == IslandBlockType.TOPSOIL_BLOCK.ordinal();
    }

    private void digBlock(ChunkMask data, int x, int y, int z, boolean foundTop, int state) {
        if (state == IslandBlockType.STONE_BLOCK.ordinal() || state == IslandBlockType.COAST_BLOCK.ordinal() || state == IslandBlockType.FERROSITE_BLOCK.ordinal()) {
            data.setBlock(x, y, z, IslandBlockType.VEIN_BLOCK.ordinal());
            if (foundTop && data.getBlock(x, y - 1, z) == IslandBlockType.SOIL_BLOCK.ordinal()) {
                data.setBlock(x, y - 1, z, IslandBlockType.TOPSOIL_BLOCK.ordinal());
            }
        }
    }
}

